/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.swagger.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.manatee.swagger.handle.ISwaggerAddHandle;
import com.manatee.swagger.plugin.SwaggerAddParam;
import com.manatee.swagger.utils.RefModelUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.Parameter;

@Service(value="SwaggerHandleGET")
public class SwaggerGetAddHandle
implements ISwaggerAddHandle {
    @Override
    public SwaggerAddParam moduleToSwaggerAddParam(String tag, JSONObject module) {
        JSONArray moduleGetParams;
        String moduleName = module.getString("moduleName");
        String moduleCode = module.getString("moduleCode");
        String moduleDescription = module.getString("moduleDescription");
        String projectId = module.getString("projectId");
        String path = "/biz/modularity/project" + projectId + "/" + moduleCode;
        SwaggerAddParam swaggerAddParam = new SwaggerAddParam(tag, moduleName, HttpMethod.GET, path, moduleDescription);
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        JSONObject params = module.getJSONObject("params");
        if (params != null && (moduleGetParams = params.getJSONArray("get")) != null) {
            for (Object ModuleGetParam : moduleGetParams) {
                ModelRef modelRef;
                JSONObject getParamJson = JSONObject.parseObject((String)JSON.toJSONString(ModuleGetParam));
                ResolvedType type = null;
                String typeStr = RefModelUtil.getType(getParamJson.getString("TYPE"), getParamJson.getString("VALUE"));
                if ("Array".equals(typeStr)) {
                    modelRef = new ModelRef("array", (ModelReference)new ModelRef("string"));
                    type = new TypeResolver().resolve(ArrayList.class, new Type[0]);
                } else {
                    String classStr = RefModelUtil.getTypePath(typeStr);
                    modelRef = new ModelRef(typeStr);
                    if (null != classStr) {
                        try {
                            Class<?> clazz = Class.forName(classStr);
                            type = new TypeResolver().resolve(clazz, new Type[0]);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Parameter getParam = new ParameterBuilder().name(getParamJson.getString("KEY")).defaultValue(getParamJson.getString("VALUE")).description(getParamJson.getString("DESC")).type(type).modelRef((ModelReference)modelRef).parameterType("query").required(true).build();
                parameterList.add(getParam);
            }
        }
        swaggerAddParam.setRequestParams(parameterList);
        return swaggerAddParam;
    }
}

