/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dataModel.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LogicalToPhysicalProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private ProcessDataSource processDataSource;
    @Resource
    private ProcessChain processChain;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    protected InputUtil inputUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"model"});
        JSONObject conf = content.getStepConf();
        String model = conf.getString("model");
        Long projectId = content.getProjectId();
        String handleType = conf.getString("handleType");
        Object returnDataShow = content.getStepConf().get((Object)"returnDataShow");
        JSONObject moduleJson = content.getModule();
        JSONObject logicBaseJson = this.processDataSource.getDataModel(projectId, model);
        if (logicBaseJson != null) {
            List steps = null;
            if (StringUtils.equals((CharSequence)logicBaseJson.getString("convertLtpState"), (CharSequence)"1")) {
                Long convertLtpModuleId = logicBaseJson.getLong("convertLtpModuleId");
                ModuleBO moduleBO = this.processDataSource.getModule(projectId, convertLtpModuleId);
                if (moduleBO == null || moduleBO.getSteps() == null) {
                    BizException exception = new BizException(ResultCode.SYSTEM_ERROR, "module_is_null");
                    if (moduleBO != null) {
                        exception.putDefaultParam(moduleBO.getCode());
                    } else {
                        exception.putDefaultParam("ID:" + convertLtpModuleId);
                    }
                    throw exception;
                }
                steps = moduleBO.getSteps();
                JSONObject tempModuleJson = new JSONObject();
                tempModuleJson.put("systemVersion", (Object)moduleBO.getSystemVersion());
                tempModuleJson.put("name", (Object)moduleBO.getName());
                tempModuleJson.put("url", (Object)moduleBO.getPath());
                tempModuleJson.put("lowcodeModule", (Object)moduleBO.getCode());
                content.setModule(tempModuleJson);
            }
            String logicKey = "logic";
            String physicsKey = "physics";
            List attrList = this.processDataSource.getDataModelLogicAttr(projectId, logicBaseJson.getLong("id"));
            StringBuilder paramsStr = new StringBuilder();
            if (attrList != null && attrList.size() > 0) {
                for (Map attr : attrList) {
                    paramsStr.append(physicsKey + "." + attr.get("attrCode").toString() + "=" + logicKey + "." + attr.get("attrCode").toString() + ";");
                }
            }
            String paramsKey = conf.getString("paramsKey");
            if (StringUtils.equals((CharSequence)handleType, (CharSequence)"batch")) {
                List list = (List)content.getRequest().get(paramsKey);
                if (list != null) {
                    ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(list.size());
                    for (Object obj : list) {
                        Map<String, Object> resultMap = this.executeConvert(content, paramsStr.toString(), obj, logicKey, physicsKey, steps);
                        resultList.add(resultMap);
                    }
                    content.setModule(moduleJson);
                    if (returnDataShow == null || Boolean.parseBoolean(returnDataShow.toString())) {
                        this.outputUtil.setDefaultReturnKey(content, "outputData");
                    }
                    this.outputUtil.handleAndPutData(content, resultList);
                }
            } else {
                Object paramsObj = content.getRequest().get(paramsKey);
                Map<String, Object> resultMap = this.executeConvert(content, paramsStr.toString(), paramsObj, logicKey, physicsKey, steps);
                content.setModule(moduleJson);
                if (returnDataShow == null || Boolean.valueOf(returnDataShow.toString()).booleanValue()) {
                    this.outputUtil.setDefaultReturnKey(content, "outputData");
                }
                this.outputUtil.handleAndPutData(content, resultMap);
            }
        }
    }

    private Map<String, Object> executeConvert(ProcessContent content, String paramsStr, Object paramsObj, String logicKey, String physicsKey, List<Step> steps) throws BizException {
        Map<String, Object> customConvertResult;
        Map physicsMap;
        Map<String, Object> defaultConvertResult = this.getHandleObject(paramsStr, logicKey, paramsObj);
        Map resultMap = (Map)defaultConvertResult.get(physicsKey);
        if (steps != null && steps.size() > 0 && (physicsMap = (Map)(customConvertResult = this.executeSteps(content, steps, logicKey, paramsObj, defaultConvertResult)).get(physicsKey)) != null) {
            resultMap.putAll(physicsMap);
        }
        return resultMap;
    }

    private Map<String, Object> executeSteps(ProcessContent content, List<Step> steps, String paramsKey, Object paramsObj, Map<String, Object> defaultConvertResult) throws BizException {
        JSONObject params = new JSONObject();
        params.put(paramsKey, paramsObj);
        params.putAll(defaultConvertResult);
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)params);
        moduleContent.setTransactionCon(content.getTransactionCon());
        moduleContent.setModule(content.getModule());
        params.put("tempContext", content.getRequest("tempContext"));
        params.put("cells", content.getRequest("cells"));
        this.processChain.executeSteps(moduleContent, steps);
        Map moduleResponse = moduleContent.getResponse();
        return moduleResponse;
    }

    private Map<String, Object> getHandleObject(String paramsStr, String paramsKey, Object paramsObj) throws BizException {
        JSONObject params = new JSONObject();
        params.put(paramsKey, paramsObj);
        ProcessContent moduleContent = new ProcessContent();
        moduleContent.setRequest((Map)params);
        Step step = new Step();
        JSONObject confTemp = new JSONObject();
        confTemp.put("params", (Object)paramsStr);
        step.setConf(confTemp);
        moduleContent.setStep(step);
        Map mapResult = this.inputUtil.getHandleObject(moduleContent);
        return mapResult;
    }

    public String getName() {
        return "logicalToPhysicalProcess";
    }
}

