/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.source;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.config.ManateeConfig;
import com.manatee.lowcode.baseModule.manager.BaseModuleUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ModuleBO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="processDataSource")
public class ProcessDataSourceImpl
extends ProcessDataSource {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessDataSourceImpl.class);
    private static String defaultDatabaseProductName;
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private BaseModuleUtil baseModuleUtil;
    @Resource
    private ManateeConfig manateeConfig;

    @Value(value="${default-database-product-name:mysql}")
    private void setDefaultDatabaseProductName(String defaultDatabaseProductName) {
        ProcessDataSourceImpl.defaultDatabaseProductName = defaultDatabaseProductName;
    }

    public ModuleBO getDataSource(String code, Long projectId) throws BizException {
        String requestMode;
        Long projectDataId;
        String systemVersion;
        String params;
        JSONObject baseModule;
        if (StringUtil.isBlank((String)code)) {
            return null;
        }
        String configDataSourceTypeNew = this.manateeConfig.getConfigData().getSourceType();
        String configDataSourceType = this.manateeConfig.getConfigDataSourceType();
        if (projectId == 0L && this.baseModuleUtil.getPROCESS_CONF_MAP().containsKey(code)) {
            baseModule = this.baseModuleUtil.getPROCESS_CONF_MAP().get(code);
            baseModule.put("moduleName", (Object)code);
            baseModule.put("moduleCode", (Object)code);
            baseModule.put("projectId", (Object)0);
        } else if (StringUtil.isNotBlank((String)configDataSourceType) && StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceType) || StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceTypeNew)) {
            baseModule = BaseModuleUtil.getCUSTOM_PROCESS_CONF_MAP().get(projectId + "-" + code);
            baseModule.put("moduleName", (Object)code);
            baseModule.put("moduleCode", (Object)code);
            baseModule.put("projectId", (Object)projectId);
        } else {
            DBQuery moduleDbQuery = new DBQuery();
            moduleDbQuery.setDatabaseProductName(defaultDatabaseProductName);
            moduleDbQuery.setTable("lowcode_base_module");
            moduleDbQuery.setSelectOne(Boolean.valueOf(true));
            moduleDbQuery.setCamelCase(Boolean.valueOf(true));
            moduleDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
            if (projectId != null) {
                moduleConditionMap.put("project_id", projectId);
            }
            moduleConditionMap.put("module_code", code);
            moduleConditionMap.put("valid", 0);
            moduleDbQuery.setConditionMap(moduleConditionMap);
            moduleDbQuery.setDb("hainiu_lowcode");
            baseModule = (JSONObject)this.dbReadUtil.find(moduleDbQuery);
        }
        if (baseModule == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        String interrupt = baseModule.getString("interrupt");
        Map interruptMap = null;
        if (StringUtil.isNotBlank((String)interrupt)) {
            interruptMap = this.formatInterrupt(JSONObject.parseObject((String)interrupt));
        }
        moduleBO.setInterrupt(interruptMap);
        Boolean isLogin = baseModule.getBoolean("isLogin");
        if (isLogin != null && isLogin.booleanValue()) {
            moduleBO.setLogin(false);
        } else {
            moduleBO.setLogin(true);
        }
        moduleBO.setId(baseModule.getLong("id"));
        String mock = baseModule.getString("mock");
        if (StringUtil.isNotBlank((String)mock)) {
            JSONObject mockJson = JSONObject.parseObject((String)mock);
            moduleBO.setMock(mockJson);
        }
        if (StringUtil.isNotBlank((String)(params = baseModule.getString("params")))) {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            moduleBO.setParams(paramsJson);
        }
        if (StringUtil.isNotBlank((String)(systemVersion = baseModule.getString("systemVersion")))) {
            moduleBO.setSystemVersion(systemVersion);
        }
        if ((projectDataId = baseModule.getLong("projectId")) != null) {
            moduleBO.setProjectId(projectDataId);
        }
        if (StringUtil.isNotBlank((String)(requestMode = baseModule.getString("requestMode")))) {
            moduleBO.setRequestMode(requestMode);
        }
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        moduleBO.setModuleType(baseModule.getInteger("moduleType"));
        moduleBO.setPath("project" + baseModule.getString("projectId") + "/" + baseModule.getString("moduleCode"));
        return moduleBO;
    }

    public ModuleBO getModuleByVersion(String code, Long projectId, String moduleVersion) throws BizException {
        String requestMode;
        Long projectDataId;
        String systemVersion;
        String params;
        JSONObject baseModule;
        if (StringUtil.isBlank((String)code)) {
            return null;
        }
        if (projectId == 0L && this.baseModuleUtil.getPROCESS_CONF_MAP().containsKey(code)) {
            baseModule = this.baseModuleUtil.getPROCESS_CONF_MAP().get(code);
        } else {
            String table = "lowcode_base_module_history";
            String project_id = "project_id";
            String valid = "valid";
            String module_code = "module_code";
            String module_version = "module_version";
            if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
                table = "LOWCODE_BASE_MODULE_HISTORY";
                project_id = "PROJECT_ID";
                valid = "VALID";
                module_code = "MODULE_CODE";
                module_version = "MODULE_VERSION";
            }
            DBQuery moduleDbQuery = new DBQuery();
            moduleDbQuery.setDatabaseProductName(defaultDatabaseProductName);
            moduleDbQuery.setTable(table);
            moduleDbQuery.setSelectOne(Boolean.valueOf(true));
            moduleDbQuery.setCamelCase(Boolean.valueOf(true));
            moduleDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
            if (projectId != null) {
                moduleConditionMap.put(project_id, projectId);
            }
            moduleConditionMap.put(module_code, code);
            moduleConditionMap.put(valid, 0);
            moduleConditionMap.put(module_version, moduleVersion);
            moduleDbQuery.setConditionMap(moduleConditionMap);
            moduleDbQuery.setDb("hainiu_lowcode");
            baseModule = (JSONObject)this.dbReadUtil.find(moduleDbQuery);
        }
        if (baseModule == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        String interrupt = baseModule.getString("interrupt");
        Map interruptMap = null;
        if (StringUtil.isNotBlank((String)interrupt)) {
            interruptMap = this.formatInterrupt(JSONObject.parseObject((String)interrupt));
        }
        moduleBO.setInterrupt(interruptMap);
        Boolean isLogin = baseModule.getBoolean("isLogin");
        if (isLogin != null && isLogin.booleanValue()) {
            moduleBO.setLogin(false);
        } else {
            moduleBO.setLogin(true);
        }
        moduleBO.setId(baseModule.getLong("moduleId"));
        String mock = baseModule.getString("mock");
        if (StringUtil.isNotBlank((String)mock)) {
            JSONObject mockJson = JSONObject.parseObject((String)mock);
            moduleBO.setMock(mockJson);
        }
        if (StringUtil.isNotBlank((String)(params = baseModule.getString("params")))) {
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            moduleBO.setParams(paramsJson);
        }
        if (StringUtil.isNotBlank((String)(systemVersion = baseModule.getString("systemVersion")))) {
            moduleBO.setSystemVersion(systemVersion);
        }
        if ((projectDataId = baseModule.getLong("projectId")) != null) {
            moduleBO.setProjectId(projectDataId);
        }
        if (StringUtil.isNotBlank((String)(requestMode = baseModule.getString("requestMode")))) {
            moduleBO.setRequestMode(requestMode);
        }
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        moduleBO.setPath("project" + baseModule.getString("projectId") + "/" + baseModule.getString("moduleCode"));
        return moduleBO;
    }

    public JSONObject getProjectConf(Long projectId) throws BizException {
        String configDataSourceType = this.manateeConfig.getConfigDataSourceType();
        if (StringUtil.isNotBlank((String)configDataSourceType) && StrUtil.equals((CharSequence)"file", (CharSequence)configDataSourceType)) {
            JSONObject jsonObject = BaseModuleUtil.getCUSTOM_PROJECT_CONF_MAP().get(projectId.toString());
            if (jsonObject == null) {
                return new JSONObject();
            }
            return jsonObject.getJSONObject("projectConf");
        }
        JSONObject projectConf = new JSONObject();
        try {
            DBQuery projectConfDbQuery = new DBQuery();
            projectConfDbQuery.setDatabaseProductName(defaultDatabaseProductName);
            projectConfDbQuery.setTable("lowcode_project_conf");
            projectConfDbQuery.setSelectOne(Boolean.valueOf(true));
            projectConfDbQuery.setCamelCase(Boolean.valueOf(true));
            projectConfDbQuery.setUpperOrLowerCase("lowerCase");
            HashMap<String, Long> projectConfConditionMap = new HashMap<String, Long>();
            projectConfConditionMap.put("project_id", projectId);
            projectConfDbQuery.setConditionMap(projectConfConditionMap);
            projectConfDbQuery.setDb("hainiu_lowcode");
            projectConf = (JSONObject)this.dbReadUtil.find(projectConfDbQuery);
            if (projectConf == null) {
                projectConf = new JSONObject();
            }
            return projectConf;
        }
        catch (Throwable e) {
            LOGGER.error("init projectConf error projectId:\u3010{}\u3011, e:{}", (Object)projectId, (Object)e);
            return projectConf;
        }
    }

    public JSONArray getProjectAllModule(Long projectId) throws BizException {
        JSONArray moduleList = new JSONArray();
        DBQuery moduleDbQuery = new DBQuery();
        moduleDbQuery.setDatabaseProductName(defaultDatabaseProductName);
        moduleDbQuery.setTable("lowcode_base_module");
        moduleDbQuery.setCamelCase(Boolean.valueOf(true));
        moduleDbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        if (projectId != null) {
            moduleConditionMap.put("project_id", projectId);
        }
        moduleConditionMap.put("valid", 0);
        moduleDbQuery.setConditionMap(moduleConditionMap);
        moduleDbQuery.setDb("hainiu_lowcode");
        moduleList = (JSONArray)this.dbReadUtil.find(moduleDbQuery);
        return moduleList;
    }

    public JSONArray getAllProjectConf() throws BizException {
        JSONArray projectConfArr = new JSONArray();
        try {
            DBQuery projectConfDbQuery = new DBQuery();
            projectConfDbQuery.setDatabaseProductName(defaultDatabaseProductName);
            projectConfDbQuery.setTable("lowcode_project_conf");
            projectConfDbQuery.setCamelCase(Boolean.valueOf(true));
            projectConfDbQuery.setUpperOrLowerCase("lowerCase");
            projectConfDbQuery.setDb("hainiu_lowcode");
            projectConfArr = (JSONArray)this.dbReadUtil.find(projectConfDbQuery);
            if (projectConfArr == null) {
                projectConfArr = new JSONArray();
            }
            return projectConfArr;
        }
        catch (Throwable throwable) {
            return projectConfArr;
        }
    }

    public String getDefaultDatabaseProductName() {
        return defaultDatabaseProductName;
    }

    public ModuleBO getModuleById(Long moduleId, Long projectId) throws BizException {
        if (moduleId == null) {
            return null;
        }
        DBQuery moduleDbQuery = new DBQuery();
        moduleDbQuery.setDatabaseProductName(defaultDatabaseProductName);
        moduleDbQuery.setTable("lowcode_base_module");
        moduleDbQuery.setSelectOne(Boolean.valueOf(true));
        moduleDbQuery.setCamelCase(Boolean.valueOf(true));
        moduleDbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        if (projectId != null) {
            moduleConditionMap.put("project_id", projectId);
        }
        moduleConditionMap.put("id", moduleId);
        moduleConditionMap.put("valid", 0);
        moduleDbQuery.setConditionMap(moduleConditionMap);
        moduleDbQuery.setDb("hainiu_lowcode");
        JSONObject baseModule = (JSONObject)this.dbReadUtil.find(moduleDbQuery);
        if (baseModule == null) {
            return null;
        }
        ModuleBO moduleBO = new ModuleBO();
        moduleBO.setName(baseModule.getString("moduleName"));
        moduleBO.setCode(baseModule.getString("moduleCode"));
        JSONObject processConf = JSONObject.parseObject((String)baseModule.getString("processConf"), (Feature[])new Feature[]{Feature.OrderedField});
        if (processConf != null) {
            List steps = ProcessDataSourceImpl.formatSteps((JSONObject)processConf);
            moduleBO.setSteps(steps);
        }
        return moduleBO;
    }

    public JSONObject getDataModelByLogicCode(Long projectId, String logicCode) throws BizException {
        String table = "lowcode_logic_base";
        String project_id = "project_id";
        String logic_code = "logic_code";
        String valid = "valid";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_BASE";
            project_id = "PROJECT_ID";
            logic_code = "LOGIC_CODE";
            valid = "VALID";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setSelectOne(Boolean.valueOf(true));
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(logic_code, logicCode);
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        JSONObject logicBaseJson = (JSONObject)this.dbReadUtil.find(dbQuery);
        return logicBaseJson;
    }

    public List<Map<String, Object>> getLogicAttrByLogicId(Long projectId, Long logicId) throws BizException {
        String table = "lowcode_logic_attribute";
        String project_id = "project_id";
        String logic_id = "logic_id";
        String valid = "valid";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_ATTRIBUTE";
            project_id = "PROJECT_ID";
            logic_id = "LOGIC_ID";
            valid = "VALID";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(logic_id, logicId);
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        List mapList = this.dbReadUtil.findList(dbQuery);
        return mapList;
    }

    public JSONObject getLogicBehaviorRelById(Long projectId, Long relId) throws BizException {
        String table = "lowcode_logic_behavior_rel";
        String project_id = "project_id";
        String id = "id";
        String valid = "valid";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_BEHAVIOR_REL";
            project_id = "PROJECT_ID";
            id = "ID";
            valid = "VALID";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setSelectOne(Boolean.valueOf(true));
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(id, relId);
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        JSONObject logicBaseJson = (JSONObject)this.dbReadUtil.find(dbQuery);
        return logicBaseJson;
    }

    public JSONObject getLogicBehaviorById(Long projectId, Long behaviorId) throws BizException {
        String table = "lowcode_logic_behavior";
        String project_id = "project_id";
        String id = "id";
        String valid = "valid";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_BEHAVIOR";
            project_id = "PROJECT_ID";
            id = "ID";
            valid = "VALID";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setSelectOne(Boolean.valueOf(true));
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(id, behaviorId);
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        JSONObject logicBaseJson = (JSONObject)this.dbReadUtil.find(dbQuery);
        return logicBaseJson;
    }

    public List<Map<String, Object>> getBehaviorParamsByBehaviorId(Long behaviorId, Integer paramClass) throws BizException {
        String table = "lowcode_logic_behavior_params";
        String behavior_id = "behavior_id";
        String param_class = "param_class";
        String valid = "valid";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_BEHAVIOR_PARAMS";
            behavior_id = "behavior_id";
            param_class = "PARAM_CLASS";
            valid = "VALID";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Number> moduleConditionMap = new HashMap<String, Number>();
        moduleConditionMap.put(behavior_id, behaviorId);
        if (paramClass != null) {
            moduleConditionMap.put(param_class, paramClass);
        }
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        List mapList = this.dbReadUtil.findList(dbQuery);
        return mapList;
    }

    public Long getModuleIdByImplLogicCode(Long projectId, String implLogicCode) throws BizException {
        String table = "lowcode_logic_base";
        String project_id = "project_id";
        String valid = "valid";
        String logic_type = "logic_type";
        String logic_code = "logic_code";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_BASE";
            project_id = "PROJECT_ID";
            valid = "VALID";
            logic_type = "LOGIC_TYPE";
            logic_code = "LOGIC_CODE";
        }
        DBQuery logicBaseDbQuery = new DBQuery();
        logicBaseDbQuery.setDatabaseProductName(defaultDatabaseProductName);
        logicBaseDbQuery.setTable(table);
        logicBaseDbQuery.setSelectOne(Boolean.valueOf(true));
        logicBaseDbQuery.setCamelCase(Boolean.valueOf(true));
        logicBaseDbQuery.setUpperOrLowerCase("lowerCase");
        HashMap<String, Object> moduleConditionMap = new HashMap<String, Object>();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(logic_type, 3);
        moduleConditionMap.put(valid, 0);
        moduleConditionMap.put(logic_code, implLogicCode);
        logicBaseDbQuery.setConditionMap(moduleConditionMap);
        JSONObject logicBaseJson = (JSONObject)this.dbReadUtil.find(logicBaseDbQuery);
        Long logicId = logicBaseJson.getLong("id");
        table = "lowcode_logic_module_rel";
        project_id = "project_id";
        String logic_id = "logic_id";
        valid = "valid";
        String rel_type = "rel_type";
        if (defaultDatabaseProductName.equals("dameng") || defaultDatabaseProductName.equals("oracle")) {
            table = "LOWCODE_LOGIC_MODULE_REL";
            project_id = "PROJECT_ID";
            logic_id = "LOGIC_ID";
            valid = "VALID";
            rel_type = "REL_TYPE";
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDatabaseProductName(defaultDatabaseProductName);
        dbQuery.setTable(table);
        dbQuery.setCamelCase(Boolean.valueOf(true));
        dbQuery.setUpperOrLowerCase("lowerCase");
        dbQuery.setSelectOne(Boolean.valueOf(true));
        dbQuery.setColumns("module_id");
        moduleConditionMap = new HashMap();
        if (projectId != null) {
            moduleConditionMap.put(project_id, projectId);
        }
        moduleConditionMap.put(logic_id, logicId);
        moduleConditionMap.put(rel_type, 1);
        moduleConditionMap.put(valid, 0);
        dbQuery.setConditionMap(moduleConditionMap);
        JSONObject json = (JSONObject)this.dbReadUtil.find(dbQuery);
        System.out.println(json);
        Long moduleId = null;
        if (json != null && !json.isEmpty()) {
            moduleId = json.getLong("moduleId");
        }
        return moduleId;
    }
}

