/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process.performance;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.ProcessChain;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.ProcessContent;
import com.manatee.redis.domain.CacheBO;
import com.manatee.redis.util.ManateeCacheUtil;
import com.manatee.redis.util.RedisDbUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CacheProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(CacheProcess.class);
    @Resource
    private ManateeCacheUtil manateeCacheUtil;
    @Resource
    private ProcessChain processChain;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        String key = this.variableUtil.calVarInConf(content, "key");
        String type = content.getStepConfString("type");
        int db = RedisDbUtil.getRedisDB(content);
        Integer minute = 2;
        String minuteConf = this.variableUtil.calVarInConf(content, "minute");
        if (minuteConf != null && NumberUtils.isInteger((String)minuteConf.toString())) {
            minute = Integer.valueOf(minuteConf.toString());
        }
        CacheBO cacheBO = new CacheBO();
        cacheBO.setDb(db);
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(content.getProjectId() != null ? content.getProjectId() + "-" : "").append(content.getCode()).append("-").append(key);
        cacheBO.setKey(cacheKey.toString());
        cacheBO.setType(type);
        cacheBO.setMinute(minute);
        Object cacheData = this.manateeCacheUtil.getCache(cacheBO);
        if (cacheData != null) {
            this.log.warn("[CacheProcess.process]_biz_occur,msg: {} from {} cache", (Object)key, (Object)type);
            conf.put("returnKey", (Object)key);
            this.outputUtil.putData(content, cacheData);
            return;
        }
        this.log.warn("[CacheProcess.process]_biz_occur,msg: {} not from {} cache", (Object)key, (Object)type);
        List steps = ProcessDataSource.formatSteps((JSONObject)conf);
        this.processChain.executeSteps(content, steps);
        Object value = content.getValueFromRequestOrResponse(key);
        cacheBO.setValue(value);
        this.manateeCacheUtil.setCache(cacheBO);
    }

    public String getName() {
        return "cacheProcess";
    }
}

