/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.CamelCaseUtil;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcodedb.base.DBReadUtil;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CascadeQueryUtil {
    @Resource
    private DBReadUtil dbReadUtil;
    @Resource
    private IVariableUtil variableUtil;

    public void cascadeQuery(Object dbEntities, DbClient use, DBQuery dbQuery, ProcessContent content) throws BizException {
        block7: {
            JSONArray cascades = dbQuery.getCascade();
            if (cascades == null) break block7;
            if (dbEntities instanceof List) {
                List dbEntityArrays = (List)dbEntities;
                for (Object object : cascades) {
                    JSONObject cascade = JSONObject.parseObject((String)JSON.toJSONString(object));
                    String cascadeKey = this.getCascadeKey(cascade, dbQuery, content);
                    String cascadeVal = this.getCascadeVal(cascade, dbQuery, content);
                    Map<Object, List<Object>> groupByMap = this.getCascadeEntities(cascade, dbQuery, use, content);
                    for (Object o : dbEntityArrays) {
                        Map dataItem = (Map)o;
                        if (dataItem == null || dataItem.get(cascadeKey) == null) continue;
                        String cascadeKeyObj = dataItem.get(cascadeKey).toString();
                        List<Object> cascadeGroup = groupByMap.get(cascadeKeyObj);
                        if (cascadeGroup == null) {
                            cascadeGroup = new ArrayList<Object>();
                        }
                        dataItem.put(cascadeVal, cascadeGroup);
                    }
                }
            } else {
                for (Object object : cascades) {
                    JSONObject cascade = JSONObject.parseObject((String)JSON.toJSONString(object));
                    String cascadeKey = this.getCascadeKey(cascade, dbQuery, content);
                    String cascadeVal = this.getCascadeVal(cascade, dbQuery, content);
                    Map<Object, List<Object>> groupByMap = this.getCascadeEntities(cascade, dbQuery, use, content);
                    Map dataItem = (Map)dbEntities;
                    if (dataItem == null || dataItem.get(cascadeKey) == null) continue;
                    String cascadeKeyObj = dataItem.get(cascadeKey).toString();
                    List<Object> cascadeGroup = groupByMap.get(cascadeKeyObj);
                    if (cascadeGroup == null) {
                        cascadeGroup = new ArrayList<Object>();
                    }
                    dataItem.put(cascadeVal, cascadeGroup);
                }
            }
        }
    }

    private String getCascadeVal(JSONObject cascade, DBQuery dbQuery, ProcessContent content) {
        String cascadeVal;
        String cascadeTable = cascade.getString("table");
        if (StringUtil.isNotEmpty((CharSequence)cascadeTable)) {
            cascadeTable = this.variableUtil.calVar(content, cascadeTable);
        }
        if (StringUtil.isBlank((String)(cascadeVal = cascade.getString("cascadeVal")))) {
            cascadeVal = cascadeTable + "_list";
        }
        cascadeVal = this.dbReadUtil.camelCase(cascadeVal);
        return cascadeVal;
    }

    private String getCascadeKey(JSONObject cascade, DBQuery dbQuery, ProcessContent content) {
        String cascadeKey = cascade.getString("cascadeKey");
        if (StringUtil.isNotEmpty((CharSequence)cascadeKey)) {
            cascadeKey = this.variableUtil.calVar(content, cascadeKey);
        }
        cascadeKey = this.getCamelCaseKey(dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase(), cascadeKey);
        return cascadeKey;
    }

    private Map<Object, List<Object>> getCascadeEntities(JSONObject cascade, DBQuery dbQuery, DbClient use, ProcessContent content) throws BizException {
        String cascadeColumns;
        String beCascadeedKey;
        String cascadeTable = cascade.getString("table");
        if (StringUtil.isNotEmpty((CharSequence)cascadeTable)) {
            cascadeTable = this.variableUtil.calVar(content, cascadeTable);
        }
        if (StringUtil.isNotEmpty((CharSequence)(beCascadeedKey = cascade.getString("beCascadeedKey")))) {
            beCascadeedKey = this.variableUtil.calVar(content, beCascadeedKey);
        }
        if (StringUtil.isNotEmpty((CharSequence)(cascadeColumns = cascade.getString("columns")))) {
            cascadeColumns = this.variableUtil.calVar(content, cascadeColumns);
        }
        cascadeColumns = cascadeColumns + ',' + beCascadeedKey;
        List cascadeQueryParamsArray = (List)cascade.get((Object)"queryParamsArray");
        DbEntity cascadeEntity = DbEntity.create(dbQuery.getDb() + '.' + cascadeTable);
        cascadeEntity.setQueryColumnsForDbQuery(cascadeTable, cascadeColumns).setWhereConditionListForDbQuery(cascadeTable, cascadeQueryParamsArray, content);
        try {
            List<DbEntity> cascadeEntities = use.find(cascadeEntity, ManateeListHandler.create(dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase()), (Order[])null, (Collection<Join>)null);
            if (cascadeEntities == null || cascadeEntities.isEmpty()) {
                cascadeEntities = new ArrayList<DbEntity>();
            }
            beCascadeedKey = this.getCamelCaseKey(dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase(), beCascadeedKey);
            HashMap<Object, List<Object>> groupByMap = new HashMap<Object, List<Object>>();
            for (DbEntity obj : cascadeEntities) {
                JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)obj)));
                String o = json.getString(beCascadeedKey);
                ArrayList<DbEntity> list = (ArrayList<DbEntity>)groupByMap.get(o);
                if (list == null) {
                    list = new ArrayList<DbEntity>();
                }
                list.add(obj);
                groupByMap.put(o, list);
            }
            return groupByMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getCamelCaseKey(Boolean camelCase, String upperOrLowerCase, String fieldName) {
        if (StringUtil.isNotBlank((String)upperOrLowerCase) && "upperCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toUpperCase();
        } else if (StringUtil.isNotBlank((String)upperOrLowerCase) && "lowerCase".equals(upperOrLowerCase)) {
            fieldName = fieldName.toLowerCase();
        }
        if (camelCase.booleanValue() && fieldName.contains("_")) {
            fieldName = CamelCaseUtil.camelCase((String)fieldName);
        }
        return fieldName;
    }
}

