/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.change;

import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.FunctionContentUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IntFun
extends AbstractFunction {
    private static Logger log = LoggerFactory.getLogger(IntFun.class);
    private String name = "int";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return 0;
        }
        Object obj = content.getParameter(0);
        int result = 0;
        try {
            if (obj instanceof Integer) {
                result = (Integer)obj;
            } else if (obj instanceof Double) {
                Double d2 = (Double)obj;
                result = d2.intValue();
            } else if (obj instanceof Long) {
                Long l2 = (Long)obj;
                result = l2.intValue();
            } else if (obj instanceof Float) {
                Float f = (Float)obj;
                result = f.intValue();
            } else if (obj instanceof BigInteger) {
                BigInteger bi = (BigInteger)obj;
                result = bi.intValue();
            } else if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)obj;
                result = bd.intValue();
            } else if (obj instanceof Boolean) {
                Boolean b2 = (Boolean)obj;
                result = b2 != false ? 1 : 0;
            } else if (obj instanceof Character) {
                Character c = (Character)obj;
                result = c.hashCode();
            } else {
                String s = (String)obj;
                if (NumberUtil.isNumber((CharSequence)s)) {
                    result = Double.valueOf(s).intValue();
                }
            }
            return result;
        }
        catch (Throwable e) {
            log.error("[IntFun.doFunction]_exception", e);
            FunctionContentUtil.addUnBlockError((FunctionContent)content, (String)String.format("\u51fd\u6570\uff1a%s\uff0c\u8f6cint\u5931\u8d25", this.getName()), (String)this.getName());
            return null;
        }
    }

    public Integer getMinParamSize() {
        return 1;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

