/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.util;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IDBManager;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="ProcessFormConfUtil")
public class ProcessFormConfUtil {
    @Resource
    private IDBManager dbManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void caseSensitiveSettings(ProcessContent content) throws BizException {
        String queryParams = content.getStepConf().getString("queryParams");
        Map<String, Object> queryParamsMap = this.dbManager.getQueryParams(content);
        String inStr = content.getStepConf().getString("in");
        String join = content.getStepConf().getString("join");
        String cascade = content.getStepConf().getString("cascade");
        String pkName = content.getStepConf().getString("pkName");
        try {
            Map<String, Object> insertParams = this.dbManager.getInsertParams(content);
            if (insertParams == null) {
                // empty if block
            }
        }
        catch (BizException insertParams) {
            // empty catch block
        }
        try {
            Map<String, Object> updateParams = this.dbManager.getUpdateParams(content);
            if (updateParams == null) return;
            return;
        }
        catch (BizException bizException) {
            // empty catch block
        }
    }

    private void tableCaseAdaptation(ProcessContent content) {
        String table = content.getStepConf().getString("table");
        if (table == null) {
            return;
        }
        if (!table.startsWith("\"") && !table.endsWith("\"")) {
            table = "\"" + table + "\"";
            content.getStepConf().put("table", (Object)table);
        }
    }

    private void columnsCaseAdaptation(ProcessContent content) {
        String columnStr = content.getStepConf().getString("columns");
        if (columnStr == null) {
            return;
        }
        String[] columns = columnStr.split(",");
        StringBuilder newColumnsStr = new StringBuilder();
        for (String column : columns) {
            if (!(column.equals("*") || column.startsWith("\"") || column.endsWith("\""))) {
                column = "\"" + column + "\"";
            }
            newColumnsStr.append(column).append(",");
        }
        newColumnsStr.delete(newColumnsStr.length() - 1, newColumnsStr.length());
        content.getStepConf().put("columns", (Object)newColumnsStr);
    }

    private void queryParamsCaseAdaptation(ProcessContent content) {
        try {
            Map<String, Object> queryParamsMap = this.dbManager.getQueryParams(content);
            if (queryParamsMap != null) {
                StringBuilder newQueryParamsStr = new StringBuilder();
                for (Map.Entry<String, Object> item : queryParamsMap.entrySet()) {
                    newQueryParamsStr.append("\"").append(item.getKey()).append("\"").append(" = ").append(item.getValue()).append(";\n");
                }
                newQueryParamsStr.delete(newQueryParamsStr.length() - 1, newQueryParamsStr.length());
                content.getStepConf().put("queryParams", (Object)newQueryParamsStr.toString());
            }
        }
        catch (BizException bizException) {
            // empty catch block
        }
    }
}

