/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.convert.impl;

import com.manatee.common.util.tool.core.convert.AbstractConverter;
import com.manatee.common.util.tool.core.date.DateTime;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        Long mills = null;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Number) {
            mills = ((Number)value).longValue();
        } else {
            if (value instanceof TemporalAccessor) {
                return DateUtil.date((TemporalAccessor)value);
            }
            String valueStr = this.convertToStr(value);
            Date date = null;
            try {
                date = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != date) {
                mills = date.getTime();
            }
        }
        if (null == mills) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return new DateTime(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupport Date type: {}", this.targetType.getName()));
    }
}

