/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.user;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaUserProcess
implements IProcess {
    @Autowired
    private IdentityService identityService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        Object userIdsObject;
        String action = this.variableUtil.calVarInConf(content, "action");
        String userIdKey = this.variableUtil.calVarInConf(content, "userId");
        String userId = null;
        if (StringUtil.isNotBlank((String)userIdKey)) {
            userId = content.getValue(userIdKey).toString();
        }
        String userIdsKey = this.variableUtil.calVarInConf(content, "userIds");
        List userIds = new ArrayList();
        if (StringUtil.isNotBlank((String)userIdsKey) && (userIdsObject = content.getValue(userIdsKey)) instanceof List) {
            userIds = (List)userIdsObject;
        }
        String firstNameKey = this.variableUtil.calVarInConf(content, "firstName");
        String firstName = null;
        if (StringUtil.isNotBlank((String)firstNameKey)) {
            firstName = content.getValue(firstNameKey).toString();
        }
        String lastNameKey = this.variableUtil.calVarInConf(content, "lastName");
        String lastName = null;
        if (StringUtil.isNotBlank((String)lastNameKey)) {
            lastName = content.getValue(lastNameKey).toString();
        }
        String groupIdKey = this.variableUtil.calVarInConf(content, "groupId");
        Object groupId = null;
        List<Object> groupIdList = new ArrayList();
        if (StringUtil.isNotBlank((String)groupIdKey)) {
            groupId = content.getValue(groupIdKey);
            if (groupId instanceof List) {
                groupIdList = (List)groupId;
            } else if (groupId instanceof String) {
                if (groupId.toString().contains(",")) {
                    groupIdList = Arrays.asList(groupId.toString().split(","));
                } else {
                    groupIdList.add(groupId.toString());
                }
            }
        }
        String emailKey = this.variableUtil.calVarInConf(content, "email");
        String email = null;
        if (StringUtil.isNotBlank((String)emailKey)) {
            email = content.getValue(emailKey).toString();
        }
        String passwordKey = this.variableUtil.calVarInConf(content, "password");
        String password = null;
        if (StringUtil.isNotBlank((String)passwordKey)) {
            password = content.getValue(passwordKey).toString();
        }
        if (action.equalsIgnoreCase("queryUsers")) {
            UserQuery usersQuery = (UserQuery)this.identityService.createUserQuery().orderByUserId().asc();
            if (!userIds.isEmpty()) {
                String[] stringArray = new String[userIds.size()];
                usersQuery.userIdIn(userIds.toArray(stringArray));
            }
            String pageNumStr = this.variableUtil.calVarInConf(content, "pageNum");
            String string = this.variableUtil.calVarInConf(content, "pageSize");
            if (StringUtil.isNotBlank((String)pageNumStr) && StringUtil.isNotBlank((String)string)) {
                Integer pageNum = Integer.valueOf(NumberUtil.isNumber((CharSequence)pageNumStr) ? pageNumStr : content.getValue(pageNumStr).toString());
                Integer pageSize = Integer.valueOf(NumberUtil.isNumber((CharSequence)string) ? string : content.getValue(string).toString());
                int firstIndex = (pageNum - 1) * pageSize;
                usersQuery.listPage(firstIndex, pageSize.intValue());
            }
            if (StringUtil.isNotBlank((String)userId)) {
                usersQuery.userId(userId);
            }
            if (groupId != null) {
                usersQuery.memberOfGroup(groupId.toString());
            }
            List list = usersQuery.list();
            String totalCountStr = this.variableUtil.calVarInConf(content, "totalCountReturnKey");
            String totalCount = "totalCount";
            if (StringUtil.isNotBlank((String)totalCountStr)) {
                totalCount = content.getValue(totalCountStr).toString();
            }
            long count = usersQuery.count();
            this.outputUtil.putData(content, (Object)list);
            this.outputUtil.putData(content, totalCount, (Object)count);
        } else if (action.equalsIgnoreCase("queryOneUser")) {
            UserQuery userQuery = this.identityService.createUserQuery();
            if (StringUtil.isNotBlank((String)userId)) {
                userQuery.userId(userId);
            }
            User user = (User)userQuery.singleResult();
            List list = this.identityService.createGroupQuery().groupMember(userId).list();
            JSONObject userInfo = null;
            if (user != null) {
                userInfo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)user, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                userInfo.put("roleList", (Object)list);
            }
            this.outputUtil.putData(content, userInfo);
        } else if (action.equalsIgnoreCase("addUser")) {
            User user = this.identityService.newUser(userId);
            if (StringUtil.isNotBlank((String)firstName)) {
                user.setFirstName(firstName);
            }
            if (StringUtil.isNotBlank((String)lastName)) {
                user.setLastName(lastName);
            }
            if (StringUtil.isNotBlank((String)email)) {
                user.setEmail(email);
            }
            if (StringUtil.isBlank((String)password)) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "\u8bf7\u8f93\u5165\u5bc6\u7801");
            }
            user.setPassword(password);
            this.identityService.saveUser(user);
            if (!groupIdList.isEmpty()) {
                for (String string : groupIdList) {
                    this.identityService.createMembership(userId, string);
                }
            }
        } else if (action.equalsIgnoreCase("deleteUser")) {
            User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
            if (user == null) {
                throw new BizException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
            }
            this.identityService.deleteUser(userId);
        } else if (action.equalsIgnoreCase("updateUser")) {
            User user = (User)this.identityService.createUserQuery().userId(userId).singleResult();
            if (user == null) {
                throw new BizException(ResultCode.PARAM_IS_ERROR, "\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
            }
            if (StringUtil.isNotBlank((String)firstName)) {
                user.setFirstName(firstName);
            }
            if (StringUtil.isNotBlank((String)lastName)) {
                user.setLastName(lastName);
            }
            if (StringUtil.isNotBlank((String)email)) {
                user.setEmail(email);
            }
            if (!groupIdList.isEmpty()) {
                for (String string : groupIdList) {
                    this.identityService.createMembership(userId, string);
                }
            }
            if (StringUtil.isNotBlank((String)password)) {
                user.setPassword(password);
            }
            this.identityService.saveUser(user);
        }
    }

    public String getName() {
        return "camundaUserProcess";
    }
}

