/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.common.util.tool.core.io.file.FileNameUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgreeTaskHandle
implements TaskHandle {
    @Autowired
    private TaskService taskService;

    @Override
    public JSONObject handle(TaskDTO taskDTO) {
        JSONArray addSignerNodeInfoList;
        String addSignerNodeInfoStr;
        String taskId = taskDTO.getTaskId();
        Task task = taskDTO.getTask();
        String message = taskDTO.getMessage();
        Map variables = taskDTO.getVariables();
        String addSignerTypeTemp = (String)this.taskService.getVariableLocal(taskId, "ADD_SIGNER_TYPE");
        if (StrUtil.isBlank((CharSequence)addSignerTypeTemp) && StrUtil.isNotBlank((CharSequence)task.getParentTaskId())) {
            addSignerTypeTemp = (String)this.taskService.getVariableLocal(task.getParentTaskId(), "ADD_SIGNER_TYPE");
        }
        JSONObject result = new JSONObject();
        List<String> attachments = taskDTO.getAttachments();
        if (CollUtil.isNotEmpty(attachments)) {
            for (String attachment : attachments) {
                String name = FileNameUtil.getName((String)attachment);
                this.taskService.createAttachment("text/plain", taskId, task.getProcessInstanceId(), name, attachment, attachment);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(addSignerNodeInfoStr = (String)this.taskService.getVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_NODE_INFO"))) && (addSignerNodeInfoList = JSONObject.parseArray((String)addSignerNodeInfoStr)) != null && addSignerNodeInfoList.size() > 0) {
            for (int i = 0; i < addSignerNodeInfoList.size(); ++i) {
                JSONObject jsonObject = addSignerNodeInfoList.getJSONObject(i);
                if (jsonObject == null || !StringUtils.equals((CharSequence)jsonObject.getString("addSignerType"), (CharSequence)"after")) continue;
                variables.put("MANATEE_TASK_ADD_SIGNER_STATUS", BpmTaskStatusEnum.APPROVE.getStatus());
                variables.put("MANATEE_TASK_END_TIME", DateUtil.now());
                variables.put("MANATEE_FULL_MSG", message);
                this.taskService.setVariablesLocal(task.getId(), variables);
                return result;
            }
        }
        this.taskService.createComment(taskId, task.getProcessInstanceId(), message);
        this.taskService.complete(taskId, variables);
        if (StringUtils.isNotBlank((CharSequence)task.getParentTaskId())) {
            List subActiveTaskList = this.taskService.createTaskQuery().taskParentTaskId(task.getParentTaskId()).active().list();
            if (subActiveTaskList == null || subActiveTaskList.size() <= 0) {
                if (StringUtils.equals((CharSequence)addSignerTypeTemp, (CharSequence)"after")) {
                    this.taskService.createComment(task.getParentTaskId(), task.getProcessInstanceId(), message);
                    this.taskService.complete(task.getParentTaskId(), variables);
                } else {
                    this.taskService.setVariableLocal(task.getParentTaskId(), "MANATEE_TASK_ADD_SIGNER_STATUS", (Object)BpmTaskStatusEnum.RUNNING.getStatus());
                    this.taskService.setVariableLocal(task.getParentTaskId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", null);
                    this.setAllAddSignHisPass(task.getParentTaskId());
                    Task parentTask = (Task)this.taskService.createTaskQuery().taskId(task.getParentTaskId()).singleResult();
                    result.put("parentTaskAssignee", (Object)parentTask.getAssignee());
                    result.put("parentTaskId", (Object)task.getParentTaskId());
                    result.put("parentTaskAddSignerStatus", (Object)BpmTaskStatusEnum.RUNNING.getStatus());
                }
            } else {
                JSONArray taskAddSignerNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(task.getParentTaskId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO")));
                boolean isNodeEnd = true;
                for (Task task1 : subActiveTaskList) {
                    if (!task1.getDescription().startsWith("@@addSigner:" + task.getName())) continue;
                    isNodeEnd = false;
                    break;
                }
                if (isNodeEnd && taskAddSignerNodeInfos != null && taskAddSignerNodeInfos.size() > 0) {
                    JSONObject taskAddSignerNodeInfo = (JSONObject)taskAddSignerNodeInfos.get(0);
                    taskAddSignerNodeInfos.remove(0);
                    this.setAddSignHisPass(task.getParentTaskId(), taskAddSignerNodeInfo);
                    result.put("taskAddSignerNodeInfo", taskAddSignerNodeInfo.get((Object)"subTaskInfos"));
                    this.taskService.setVariableLocal(task.getParentTaskId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerNodeInfos));
                }
            }
        }
        return result;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) {
        return taskDTO;
    }

    private void setAllAddSignHisPass(String taskId) {
        Object taskAddSignerHisNodeInfoList = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        if (taskAddSignerHisNodeInfoList == null) {
            taskAddSignerHisNodeInfoList = new ArrayList();
        }
        for (Object subTaskInfoObj : taskAddSignerHisNodeInfoList) {
            if (subTaskInfoObj == null) continue;
            JSONObject subTaskInfo = (JSONObject)subTaskInfoObj;
            subTaskInfo.put("status", (Object)BpmTaskStatusEnum.APPROVE.getStatus());
        }
        this.taskService.setVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerHisNodeInfoList));
    }

    private void setAddSignHisPass(String taskId, JSONObject taskAddSignerNodeInfo) {
        if (taskAddSignerNodeInfo == null) {
            return;
        }
        String taskDefKey = taskAddSignerNodeInfo.getString("taskDefKey");
        Object taskAddSignerHisNodeInfoList = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        if (taskAddSignerHisNodeInfoList == null) {
            taskAddSignerHisNodeInfoList = new ArrayList();
        }
        for (Object subTaskInfoObj : taskAddSignerHisNodeInfoList) {
            JSONObject subTaskInfo;
            if (subTaskInfoObj == null || !(subTaskInfo = (JSONObject)subTaskInfoObj).get((Object)"taskDefKey").equals(taskDefKey)) continue;
            subTaskInfo.put("status", (Object)BpmTaskStatusEnum.APPROVE.getStatus());
        }
        this.taskService.setVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerHisNodeInfoList));
    }
}

