/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.history;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryRetrievableNodeProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ManateeTaskService manateeTaskService;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"processInstanceId"});
        String processInstanceId = this.variableUtil.calVarInConf(content, "processInstanceId");
        List<HistoricActivityInstance> finishedList = this.manateeTaskService.historyCompleteTaskOrderByDesc(processInstanceId);
        if (CollUtil.isEmpty(finishedList)) {
            return;
        }
        HistoricActivityInstance historicActivityInstance = finishedList.get(finishedList.size() - 1);
        HashSet<String> retrievableNode = new HashSet<String>();
        HashSet<String> historicNode = new HashSet<String>();
        BpmnModelInstance bpmn = this.repositoryService.getBpmnModelInstance(historicActivityInstance.getProcessDefinitionId());
        List<HistoricActivityInstance> activityTaskList = this.manateeTaskService.activityTask(processInstanceId);
        ArrayList<FlowNode> retrievableFlowNode = new ArrayList<FlowNode>();
        for (HistoricActivityInstance activityInstance : activityTaskList) {
            FlowNode activityFlowNode = (FlowNode)bpmn.getModelElementById(this.manateeTaskService.getActivityId(activityInstance));
            if (Objects.equals(activityInstance.getActivityType(), "parallelGateway") || Objects.equals(activityInstance.getActivityType(), "exclusiveGateway")) continue;
            this.manateeTaskService.selectInAllNode(activityFlowNode, retrievableFlowNode, false, false);
        }
        for (HistoricActivityInstance activityInstance : finishedList) {
            historicNode.add(this.manateeTaskService.getActivityId(activityInstance));
        }
        for (FlowNode flowNode : retrievableFlowNode) {
            if (Objects.equals(flowNode.getElementType().getTypeName(), "startEvent") || !historicNode.contains(flowNode.getId())) continue;
            retrievableNode.add(flowNode.getId());
        }
        JSONObject result = new JSONObject();
        result.put("retrievableNode", retrievableNode);
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    public String getName() {
        return "camundaQueryRetrievableNodeProcess";
    }
}

