CREATE TABLE lowcode_base_module (
    id UInt64 NOT NULL COMMENT '接口id',
    module_code String DEFAULT '' NOT NULL COMMENT '英文名称',
    module_name String DEFAULT '' NOT NULL COMMENT 'api名称',
    module_description String DEFAULT '' NOT NULL COMMENT '接口描述',
    module_version String DEFAULT 'v1.0.0' NOT NULL COMMENT '版本',
    env String DEFAULT '' NOT NULL COMMENT '环境',
    package_id Int64 DEFAULT '0' NOT NULL COMMENT '包id',
    project_id Int64 DEFAULT '0' NOT NULL COMMENT '项目id\\n0 代表系统',
    module_type Int8 DEFAULT '1' NOT NULL COMMENT '接口模块 1  , 计算模块 2 , 子模块  0 , 抽象模块 3',
    request_mode String DEFAULT 'POST' NOT NULL COMMENT '请求方式：GET/POST',
    is_login Int8 DEFAULT '0' NOT NULL COMMENT '是否需要登录，需要  0  不需要1',
    process_conf String COMMENT '流程配置',
    valid Int8 DEFAULT '0' NOT NULL COMMENT '状态\n-1 删除  \n0 正常',
    gmt_create datetime DEFAULT now() NOT NULL COMMENT '创建时间',
    gmt_modified datetime DEFAULT now() NOT NULL COMMENT '修改时间',
    params String COMMENT '参数',
    mock String COMMENT 'mock返回',
    chart_url String DEFAULT '' NOT NULL COMMENT '流程图url',
    interrupt String COMMENT '中断配置',
    create_user Int64 DEFAULT '0' NOT NULL COMMENT '创建用户id',
    modified_user Int64 DEFAULT '0' NOT NULL COMMENT '更新用户id',
    system_version String DEFAULT '' NOT NULL COMMENT '接口版本',
    conf String COMMENT '接口配置',
    sort Int32 DEFAULT '1' NOT NULL COMMENT '排序'
) engine = MergeTree()
 order by id
 primary key id
 COMMENT '积木模块'