/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.process.js.JsProcess;
import com.manatee.lowcode.util.CacheRamUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.config.ManateeDataSource;
import com.manatee.lowcodedb.constant.DatabaseProductNameEnum;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.process.DynamicDbProcess;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataAnalysisProcess
implements IProcess {
    private static final Logger log = LoggerFactory.getLogger(DataAnalysisProcess.class);
    private static Logger LOGGER = LoggerFactory.getLogger(DataAnalysisProcess.class);
    @Value(value="${default-database-product-name:mysql}")
    private String defaultDatabaseProductName;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private DynamicDbProcess dynamicDbProcess;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected ManateeDataSource manateeDataSource;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private CacheRamUtil cacheRamUtil;
    @Resource
    private JsProcess jsProcess;

    public void process(ProcessContent content) throws BizException {
        boolean manateeQueryColumns;
        String db = this.variableUtil.calVarInConf(content, "db");
        Object isDebugTemp = content.getTempContent("debug");
        boolean needCache = isDebugTemp == null || "false".equals(isDebugTemp.toString());
        String returnKey = content.getStepConf().getString("returnKey");
        int type = 2;
        if (content.getRequest("type") != null && NumberUtils.isNumber((String)content.getRequest("type").toString())) {
            type = Integer.parseInt(content.getRequest("type").toString());
        }
        if (needCache && this.cacheRamUtil.getCache(returnKey) != null) {
            this.cacheRamUtil.getCache(returnKey);
            return;
        }
        Connection conn = null;
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get((String)db);
        try {
            conn = dataSource.getConnection();
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            String code = DatabaseProductNameEnum.getCodeByName((String)databaseProductName);
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                this.defaultDatabaseProductName = code;
            }
        }
        catch (SQLException e) {
            try {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        this.setDatabaseSql(content);
        this.processConfUtil.checkConf(content, new String[]{"sql"});
        DBQuery dbQuery = this.dBManager.getDBQuery(content, this.defaultDatabaseProductName);
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            this.dynamicDbProcess.executeSql(content, dbQuery);
        }
        catch (BizException e) {
            throw e;
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
        Object manateeQueryColumnsTemp = content.getRequest("__manatee__self__queryColumns__");
        boolean bl = manateeQueryColumns = manateeQueryColumnsTemp != null && "true".equals(manateeQueryColumnsTemp.toString());
        if (manateeQueryColumns) {
            this.setQuerySqlColumns(content);
        } else {
            this.aggregationOperation(content, needCache, type);
        }
    }

    private void setDatabaseSql(ProcessContent content) throws BizException {
        String sql = content.getStepConf().getString("sql");
        if (sql != null) {
            sql = sql.trim();
            content.getStepConf().put("sql", (Object)sql);
            return;
        }
        throw new BizException(ResultCode.PARAM_IS_ERROR, "\u8bf7\u586b\u5199\u5bf9\u5e94\u6570\u636e\u5e93SQL\u8bed\u53e5");
    }

    private void aggregationOperation(ProcessContent content, boolean needCache, int type) throws BizException {
        JSONObject bi = content.getStepConf().getJSONObject("bi");
        JSONArray dimension = bi.getJSONArray("dimension");
        JSONArray customDimension = bi.getJSONArray("customDimension");
        JSONArray metric = bi.getJSONArray("metric");
        JSONArray customMetric = bi.getJSONArray("customMetric");
        dimension = this.handleDimension(dimension, customDimension);
        JSONArray metricArray = this.handleMetric(metric, customMetric);
        String returnKey = content.getStepConf().getString("returnKey");
        if (StringUtils.isBlank((CharSequence)returnKey)) {
            returnKey = "outputData";
        }
        if (type == 1) {
            List<Map<String, String>> fieldInfo = this.getFieldInfo(dimension, customDimension, metricArray);
            this.outputUtil.setDefaultReturnKey(content, "fieldInfo");
            this.outputUtil.handleAndPutData(content, fieldInfo);
        } else if (type == 2) {
            Object response = content.getRequest(returnKey);
            if (!(response instanceof Collection)) {
                return;
            }
            List list = (List)response;
            Map<Map<String, Object>, Map<String, List<Object>>> resultMap = this.getGroupDimensionList(list, dimension, customDimension, metricArray);
            List<Map<String, Object>> result = this.calculate(dimension, customDimension, metricArray, resultMap);
            this.outputUtil.setDefaultReturnKey(content, "values");
            this.outputUtil.handleAndPutData(content, result);
            this.setCache(content, needCache, "values", result);
        }
    }

    private JSONArray handleDimension(JSONArray dimensions, JSONArray customDimensions) {
        JSONArray newDimensions = new JSONArray();
        for (Object dimension : dimensions) {
            JSONObject dimensionJson = (JSONObject)JSONObject.toJSON(dimension);
            if (dimensionJson.containsKey((Object)"ignore") && dimensionJson.getBoolean("ignore").booleanValue()) continue;
            newDimensions.add(dimension);
        }
        if (newDimensions.isEmpty() && (customDimensions == null || customDimensions.isEmpty())) {
            throw new RuntimeException("\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return newDimensions;
    }

    private JSONArray handleMetric(JSONArray metrics, JSONArray customMetrics) {
        JSONArray newMetrics = new JSONArray();
        for (Object metric : metrics) {
            JSONObject metricJson = (JSONObject)JSONObject.toJSON(metric);
            if (metricJson.containsKey((Object)"ignore") && metricJson.getBoolean("ignore").booleanValue()) continue;
            newMetrics.add(metric);
        }
        for (Object customMetric : customMetrics) {
            JSONObject customMetricJson = (JSONObject)JSONObject.toJSON(customMetric);
            customMetricJson.put("isCustom", (Object)true);
            customMetricJson.put("field", (Object)customMetricJson.getString("name"));
            newMetrics.add((Object)customMetricJson);
        }
        if (newMetrics.isEmpty()) {
            throw new RuntimeException("\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return newMetrics;
    }

    private void setCache(ProcessContent content, boolean needCache, String returnKey, List<Map<String, Object>> result) {
        String cache = content.getStepConf().getString("cache");
        if (needCache && cache != null && !"0".equals(cache)) {
            String cacheUnit;
            long cacheTime = Long.parseLong(cache);
            switch (cacheUnit = content.getStepConf().getString("cacheUnit")) {
                case "m": {
                    cacheTime *= 60L;
                    break;
                }
                case "h": {
                    cacheTime *= 3600L;
                    break;
                }
                case "d": {
                    cacheTime *= 86400L;
                }
            }
            this.cacheRamUtil.setCache(returnKey, result, Long.valueOf(cacheTime));
        }
    }

    private Map<Map<String, Object>, Map<String, List<Object>>> getGroupDimensionList(List<Object> dataList, JSONArray dimensions, JSONArray customDimensions, JSONArray metrics) {
        HashMap<Map<String, Object>, Map<String, List<Object>>> resultMap = new HashMap<Map<String, Object>, Map<String, List<Object>>>();
        for (Object object : dataList) {
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)object);
            HashMap<String, Object> keyMap = new HashMap<String, Object>(dimensions.size());
            for (Object dimension : dimensions) {
                JSONObject dimensionJson = (JSONObject)JSONObject.toJSON(dimension);
                if (dimensionJson.containsKey((Object)"ignore") && dimensionJson.getBoolean("ignore").booleanValue()) continue;
                String key = dimensionJson.getString("field");
                Object value = jsonObject.get((Object)key);
                keyMap.put(key, value);
            }
            if (customDimensions != null && customDimensions.size() > 0) {
                for (Object customDimension : customDimensions) {
                    JSONObject customDimensionJson = (JSONObject)JSONObject.toJSON(customDimension);
                    ProcessContent processContent = this.jsProcessFun(jsonObject, customDimensionJson.get((Object)"expression"));
                    String customDimensionKey = customDimensionJson.getString("name");
                    if (processContent.getResponse() == null || processContent.getResponse().size() <= 0) continue;
                    keyMap.put(customDimensionKey, processContent.getResponse().get(customDimensionKey));
                }
            }
            Map valueMap = new HashMap(metrics.size());
            if (resultMap.containsKey(keyMap)) {
                valueMap = (Map)resultMap.get(keyMap);
            }
            for (Object metric : metrics) {
                JSONObject metricJson = (JSONObject)JSONObject.toJSON(metric);
                if (metricJson.containsKey((Object)"ignore") && metricJson.getBoolean("ignore").booleanValue()) continue;
                String key = metricJson.getString("field");
                Object value = null;
                if (metricJson.containsKey((Object)"isCustom") && metricJson.getBoolean("isCustom").booleanValue()) {
                    ProcessContent processContent = this.jsProcessFun(jsonObject, metricJson.get((Object)"expression"));
                    if (processContent.getResponse() != null && processContent.getResponse().size() > 0) {
                        Map customMetricResponse = processContent.getResponse();
                        value = customMetricResponse.get(key);
                    }
                } else {
                    value = jsonObject.get((Object)key);
                }
                List<Object> valueList = valueMap.isEmpty() || !valueMap.containsKey(key) ? new ArrayList<Object>() : (List)valueMap.get(key);
                valueList.add(value);
                valueMap.put(key, valueList);
            }
            resultMap.put(keyMap, valueMap);
        }
        return resultMap;
    }

    private List<Map<String, Object>> calculate(JSONArray dimensions, JSONArray customDimensions, JSONArray metrics, Map<Map<String, Object>, Map<String, List<Object>>> resultMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, String> newDimensionMap = new HashMap<String, String>(dimensions.size());
        for (Object dimension : dimensions) {
            JSONObject dimensionJson = (JSONObject)JSONObject.toJSON(dimension);
            newDimensionMap.put(dimensionJson.getString("field"), dimensionJson.getString("field"));
        }
        for (Object customDimension : customDimensions) {
            JSONObject customDimensionJson = (JSONObject)JSONObject.toJSON(customDimension);
            String name = customDimensionJson.getString("name");
            newDimensionMap.put(name, name);
        }
        for (Map.Entry<Map<String, Object>, Map<String, List<Object>>> aMap : resultMap.entrySet()) {
            Map<String, Object> objKey = aMap.getKey();
            Map<String, List<Object>> objValue = aMap.getValue();
            HashMap map = new HashMap(dimensions.size() + metrics.size());
            for (Map.Entry<String, Object> aMapTemp : objKey.entrySet()) {
                map.put(newDimensionMap.get(aMapTemp.getKey()), aMapTemp.getValue());
            }
            for (Object metric : metrics) {
                JSONObject metricJson = (JSONObject)JSONObject.toJSON(metric);
                String calculationSymbol = metricJson.getString("agg");
                if (StringUtils.isBlank((CharSequence)calculationSymbol)) {
                    calculationSymbol = "none";
                }
                String key = metricJson.getString("field");
                List<Object> valueList = objValue.get(key);
                Object value = null;
                switch (calculationSymbol) {
                    case "sum": {
                        value = this.sumFun(valueList);
                        break;
                    }
                    case "avg": {
                        value = this.avgFun(valueList);
                        break;
                    }
                    case "median": {
                        value = this.medianFun(valueList);
                        break;
                    }
                    case "count": {
                        value = this.countFun(valueList);
                        break;
                    }
                    case "count_distinct": {
                        value = this.countDistinctFun(valueList);
                        break;
                    }
                    case "max": {
                        value = this.maximumFun(valueList);
                        break;
                    }
                    case "min": {
                        value = this.minimumFun(valueList);
                        break;
                    }
                    case "percentile": {
                        double percentileValue = metricJson.getDoubleValue("percentileValue");
                        value = this.percentileFun(valueList, percentileValue);
                    }
                }
                String type = metricJson.getString("cast");
                if (StringUtils.isBlank((CharSequence)type) || "none".equals(type)) {
                    type = metricJson.getString("type");
                }
                Date dateValue = null;
                switch (type) {
                    case "int": {
                        Double decimalValue = Double.parseDouble(value.toString());
                        value = (int)Math.floor(decimalValue);
                        break;
                    }
                    case "float": {
                        value = Float.valueOf(value.toString());
                        break;
                    }
                    case "date": {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            dateValue = dateFormat.parse(value.toString());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        value = dateValue;
                        break;
                    }
                    case "datetime": {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            dateValue = dateFormat.parse(value.toString());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        value = dateValue;
                        break;
                    }
                    case "string": {
                        value = value.toString();
                    }
                }
                map.put(key, value);
            }
            result.add(map);
        }
        return result;
    }

    private List<Map<String, String>> getFieldInfo(JSONArray dimensions, JSONArray customDimensions, JSONArray metrics) {
        HashMap<String, String> field;
        String title;
        String name;
        ArrayList<Map<String, String>> fieldInfo = new ArrayList<Map<String, String>>();
        for (Object dimension : dimensions) {
            JSONObject dimensionJson = (JSONObject)JSONObject.toJSON(dimension);
            name = dimensionJson.getString("field");
            title = dimensionJson.getString("name");
            field = new HashMap<String, String>();
            field.put("name", name);
            field.put("title", title);
            field.put("dataType", "string");
            field.put("biType", "dimension");
            fieldInfo.add(field);
        }
        if (customDimensions != null && customDimensions.size() > 0) {
            for (Object customDimension : customDimensions) {
                JSONObject customDimensionJson = (JSONObject)JSONObject.toJSON(customDimension);
                name = customDimensionJson.getString("name");
                title = customDimensionJson.getString("field");
                title = StringUtils.isBlank((CharSequence)title) ? name : title;
                field = new HashMap();
                field.put("name", name);
                field.put("title", title);
                field.put("dataType", "string");
                field.put("biType", "dimension");
                fieldInfo.add(field);
            }
        }
        for (Object metric : metrics) {
            JSONObject metricJson = (JSONObject)JSONObject.toJSON(metric);
            name = metricJson.getString("field");
            title = metricJson.getString("name");
            String biType = metricJson.getString("type");
            field = new HashMap();
            field.put("name", name);
            field.put("title", title);
            field.put("dataType", biType);
            field.put("biType", "measure");
            fieldInfo.add(field);
        }
        return fieldInfo;
    }

    private void setQuerySqlColumns(ProcessContent content) {
        String returnKey = content.getStepConf().getString("returnKey");
        returnKey = returnKey == null ? "outputData" : returnKey;
        Object response = content.getRequest(returnKey);
        if (response instanceof Collection) {
            List list = (List)response;
            Map map = (Map)list.get(0);
            ArrayList columns = new ArrayList();
            ArrayList dimension = new ArrayList();
            ArrayList metric = new ArrayList();
            for (Map.Entry aMap : map.entrySet()) {
                Object value = aMap.getValue();
                if (value == null) continue;
                HashMap column = new HashMap();
                column.put("table", "");
                column.put("field", aMap.getKey());
                column.put("name", aMap.getKey());
                if (value instanceof Number) {
                    column.put("type", "number");
                    metric.add(column);
                } else if (value instanceof Date) {
                    column.put("type", "Date");
                    dimension.add(column);
                } else {
                    column.put("type", "string");
                    dimension.add(column);
                }
                columns.add(column);
            }
            HashMap result = new HashMap();
            result.put("columns", columns);
            result.put("dimension", dimension);
            result.put("metric", metric);
            HashMap sqlResult = new HashMap();
            sqlResult.put(content.getStepConf().getString("id"), result);
            content.putRequest("sqlResult", sqlResult);
        }
    }

    private Object sumFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        float sum = 0.0f;
        for (Object o : dataList) {
            if (o == null) continue;
            float f = ((Number)o).floatValue();
            sum += f;
        }
        return Float.valueOf(sum);
    }

    private Object avgFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        float sum = 0.0f;
        for (Object o : dataList) {
            if (o == null) continue;
            float f = ((Number)o).floatValue();
            sum += f;
        }
        return Float.valueOf(sum / (float)dataList.size());
    }

    private Object medianFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        int length = dataList.size();
        Object[] arr = dataList.toArray();
        Arrays.sort(arr);
        float median = 0.0f;
        median = length % 2 == 0 ? (((Number)arr[length / 2 - 1]).floatValue() + ((Number)arr[length / 2]).floatValue()) / 2.0f : ((Number)arr[length / 2]).floatValue();
        return Float.valueOf(median);
    }

    private Object countFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        return dataList.size();
    }

    private Object countDistinctFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        dataList = dataList.stream().distinct().collect(Collectors.toList());
        return dataList.size();
    }

    private Object maximumFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        return Collections.max(dataList);
    }

    private Object minimumFun(List dataList) {
        if (dataList == null) {
            return 0;
        }
        return Collections.min(dataList);
    }

    private Object percentileFun(List dataList, double percentile) {
        if (dataList == null || dataList.size() == 0) {
            return 0;
        }
        percentile /= 100.0;
        double[] array = new double[dataList.size()];
        for (int i = 0; i < dataList.size(); ++i) {
            array[i] = Double.parseDouble(dataList.get(i).toString());
        }
        Arrays.sort(array);
        double x = (double)(array.length - 1) * percentile;
        int i = (int)x;
        double j = x - (double)i;
        return (1.0 - j) * array[i] + j * array[i + 1];
    }

    private ProcessContent jsProcessFun(JSONObject jsonObject, Object jsCode) {
        ProcessContent processContent = new ProcessContent();
        Step step = new Step();
        JSONObject confJson = new JSONObject();
        confJson.put("jsCode", jsCode);
        step.setConf(confJson);
        processContent.setStep(step);
        processContent.setRequest((Map)jsonObject);
        try {
            this.jsProcess.process(processContent);
        }
        catch (BizException e) {
            log.error("\u81ea\u5b9a\u4e49\u5ea6\u91cf\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return processContent;
    }

    public String getName() {
        return "dataAnalysisProcess";
    }

    private static interface FunctionSymbol {
        public static final String NONE = "none";
        public static final String SUM = "sum";
        public static final String AVER = "avg";
        public static final String MEDIAN = "median";
        public static final String COUNT = "count";
        public static final String COUNT_DISTINCT = "count_distinct";
        public static final String MAXIMUM = "max";
        public static final String MINIMUM = "min";
        public static final String PERCENTILE = "percentile";
    }

    private static interface Conf {
        public static final String BI = "bi";
        public static final String DIMENSION = "dimension";
        public static final String METRIC = "metric";
        public static final String CUSTOM_DIMENSION = "customDimension";
        public static final String CUSTOM_METRIC = "customMetric";
        public static final String FIELD = "field";
        public static final String NAME = "name";
        public static final String TYPE = "type";
        public static final String AGG = "agg";
    }
}

