/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.function.time;

import com.manatee.common.util.StringUtil;
import com.manatee.common.util.TimeUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class NowFun
extends AbstractFunction {
    private String name = "now";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        this.checkParamExist(content);
        String toFormat = (String)content.getParameter(0);
        if ("timestamp".equals(toFormat)) {
            return System.currentTimeMillis();
        }
        if (StringUtil.isNotBlank((String)toFormat)) {
            Date date = new Date();
            return TimeUtil.format2Date((Date)date, (String)toFormat);
        }
        return new Date();
    }

    public Integer getMinParamSize() {
        return 0;
    }

    public Integer getMaxParamSize() {
        return 1;
    }
}

