/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.fun.time;

import com.manatee.fun.FunctionUtil;
import com.manatee.fun.IFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.fun.util.TimeUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

@Service
public class LastDayCalFun
implements IFunction {
    private String name = "lastDayCal";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) {
        Object result = null;
        List parameters = content.getParameters();
        if (!FunctionUtil.checkParameter((List)parameters, (int)1)) {
            return result;
        }
        String condition = (String)parameters.get(0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if ("thisY".equals(condition)) {
            return this.getThisYear(parameters, calendar);
        }
        Pair<Integer, String> confDate = this.getConfDate(condition);
        if ("M".equals(confDate.getRight())) {
            calendar.add(2, (Integer)confDate.getLeft());
        } else {
            calendar.add(1, (Integer)confDate.getLeft());
        }
        String format = "yyyyMMdd";
        if (parameters.size() >= 2) {
            format = (String)parameters.get(1);
        }
        Date date = calendar.getTime();
        return TimeUtil.format2Date((Date)date, (String)format);
    }

    private String getThisYear(List<Object> parameters, Calendar calendar) {
        int year = calendar.get(1);
        String day = year + "0101";
        String format = "yyyyMMdd";
        if (parameters.size() >= 2) {
            format = (String)parameters.get(1);
        }
        if ("yyyyMMdd".equals(format)) {
            return day;
        }
        try {
            Date date = TimeUtil.format2Date((String)day, (String)"yyyyMMdd");
            return TimeUtil.format2Date((Date)date, (String)format);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected Pair<Integer, String> getConfDate(String condition) {
        String unit = "M";
        if (condition.indexOf("Y") != -1) {
            unit = "Y";
        }
        String numStr = condition.replace(unit, "");
        Integer num = Integer.valueOf(numStr);
        return Pair.of((Object)num, (Object)unit);
    }
}

