/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.elasticsearch.process;

import com.manatee.common.exception.BizException;
import com.manatee.elasticsearch.domain.ESInsert;
import com.manatee.elasticsearch.manager.ESManager;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchAddProcess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    RestHighLevelClient restHighLevelClient;
    @Resource
    private ESManager esManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"index"});
        ESInsert esInsert = this.esManager.getESInsert(content);
        BulkRequest request = this.getBulkRequest(esInsert);
        BulkResponse bulkResponse = this.getBulkResponse(request);
        Object result = this.getResult(content, bulkResponse, esInsert);
        this.outputUtil.putData(content, result);
    }

    private BulkRequest getBulkRequest(ESInsert esInsert) {
        BulkRequest request = new BulkRequest();
        String index = esInsert.getIndex();
        if (esInsert.isBatch()) {
            List<Map<String, Object>> insertColumnsBatch = esInsert.getInsertColumnsBatch();
            for (Map<String, Object> insertColumns : insertColumnsBatch) {
                Object object = insertColumns.get("id");
                if (object != null) {
                    insertColumns.remove("id");
                    request.add(new IndexRequest(index).id(object.toString()).source(insertColumns, XContentType.JSON));
                    continue;
                }
                request.add(new IndexRequest(index).source(insertColumns, XContentType.JSON));
            }
        } else {
            Map<String, Object> insertColumns = esInsert.getInsertColumns();
            Object object = insertColumns.get("id");
            if (object != null) {
                insertColumns.remove("id");
                request.add(new IndexRequest(index).id(object.toString()).source(insertColumns, XContentType.JSON));
            } else {
                request.add(new IndexRequest(index).source(insertColumns, XContentType.JSON));
            }
        }
        return request;
    }

    private BulkResponse getBulkResponse(BulkRequest request) throws BizException {
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            return bulkResponse;
        }
        catch (IOException e) {
            BizException bizException = new BizException((Throwable)e);
            bizException.setMsg(e.getMessage());
            throw bizException;
        }
    }

    private Object getResult(ProcessContent content, BulkResponse bulkResponse, ESInsert esInsert) {
        BulkItemResponse[] items = bulkResponse.getItems();
        if (esInsert.isBatch()) {
            this.outputUtil.setDefaultReturnKey(content, "count");
            return items.length;
        }
        this.outputUtil.setDefaultReturnKey(content, "id");
        if (items.length > 0) {
            return items[0].getId();
        }
        return "";
    }

    public String getName() {
        return "elasticsearchAdd";
    }
}

