/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.dubbox.process;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.utils.ReferenceConfigCache;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.ProcessCheckUtil;
import com.manatee.process.util.StringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DubboXConsumerPocess
implements IProcess {
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private ApplicationConfig manateeDubboConsumerConfig;
    @Resource
    private VariableUtil variableUtil;
    @Value(value="${dubbo.registry.address:}")
    private String registryAddress;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"interfaceName"});
        Object versionObj = content.getStepConf().get((Object)"version");
        String version = null;
        if (versionObj != null && StringUtil.isNotBlank((String)versionObj.toString())) {
            version = ProcessCheckUtil.getParam((ProcessContent)content, (String)"version");
        }
        String interfaceName = ProcessCheckUtil.getParam((ProcessContent)content, (String)"interfaceName");
        String method = ProcessCheckUtil.getParam((ProcessContent)content, (String)"method");
        String protocol = ProcessCheckUtil.getParam((ProcessContent)content, (String)"protocol");
        Object additionalInformation = content.getStepConf().get((Object)"additionalInformation");
        GenericService genericService = this.getGenericService(version, interfaceName, additionalInformation, content, protocol);
        Object[] argsArr = null;
        String[] parameterTypesArr = null;
        String lowcodeProjectId = this.variableUtil.calVarInConf(content, "lowcodeProjectId");
        String lowcodeModule = this.variableUtil.calVarInConf(content, "lowcodeModule");
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        LinkedHashMap parameterTypes = new LinkedHashMap();
        if (StringUtil.isNotBlank((String)lowcodeProjectId) && StringUtil.isNotBlank((String)lowcodeModule)) {
            args.put("projectId", Long.valueOf(lowcodeProjectId));
            args.put("code", lowcodeModule);
            args.put("params", JSONObject.toJSONString((Object)this.inputUtil.getHandleObject(content, "args")));
        } else {
            args.putAll(this.inputUtil.getHandleObject(content, "args"));
            parameterTypes.putAll(this.inputUtil.getHandleObject(content, "parameterTypes"));
        }
        if (args.size() > 0) {
            argsArr = args.values().toArray();
        }
        if (parameterTypes.size() > 0) {
            parameterTypesArr = parameterTypes.values().toArray(new String[parameterTypes.size()]);
        }
        Object result = genericService.$invoke(method, parameterTypesArr, argsArr);
        this.outputUtil.putData(content, result);
    }

    public String getName() {
        return "dubboXConsumer";
    }

    private GenericService getGenericService(String version, String interfaceName, Object additionalInformations, ProcessContent content, String protocol) {
        JSONArray joinJsonArr;
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(this.manateeDubboConsumerConfig);
        if (StringUtil.isNotBlank((String)version)) {
            reference.setVersion(version);
        }
        reference.setInterface(interfaceName);
        RegistryConfig registry = new RegistryConfig();
        registry.setAddress(this.registryAddress);
        if (additionalInformations != null && CollectionUtils.isNotEmpty((Collection)(joinJsonArr = JSONArray.parseArray((String)JSON.toJSONString((Object)additionalInformations))))) {
            for (Object entry : joinJsonArr) {
                JSONObject object = (JSONObject)entry;
                String key = object.getString("key");
                String val = object.getString("val");
                key = this.variableUtil.calVar(content, key);
                val = this.variableUtil.calVar(content, val);
                RpcContext.getContext().setAttachment(key, val);
            }
        }
        reference.setTimeout(Integer.valueOf(3000));
        reference.setGeneric(Boolean.valueOf(true));
        reference.setProtocol(protocol);
        reference.setRegistry(registry);
        ReferenceConfigCache cache = ReferenceConfigCache.getCache();
        GenericService genericService = (GenericService)cache.get(reference);
        return genericService;
    }
}

