/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.generation.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.DateUtils;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.lowcode.generation.constant.GenerationConstant;
import com.manatee.lowcode.generation.domain.GenerationProcessContentBuilder;
import com.manatee.lowcode.generation.entity.GenerateDTO;
import com.manatee.lowcode.generation.entity.ModuleDTO;
import com.manatee.lowcode.generation.entity.PackageDTO;
import com.manatee.lowcode.generation.factory.GenerationProcessContentBuilderFactory;
import com.manatee.lowcode.generation.template.base.BaseTemplate;
import com.manatee.lowcode.generation.util.GenerationFileUtil;
import com.manatee.lowcode.generation.util.PinyinUtil;
import com.manatee.lowcode.generation.util.TemplateUtils;
import com.manatee.manager.SpringContextManager;
import com.manatee.process.ProcessDataSource;
import com.manatee.process.domain.Step;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceGenerator {
    private Logger LOGGER = LoggerFactory.getLogger(SourceGenerator.class);
    private Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
    private File templateDir;
    private String sourceDirPath;
    private String outPath;
    private String projectDirName;
    private String partDirName;
    private String projectName;
    private String rootPath;

    public SourceGenerator() {
    }

    public SourceGenerator(String rootPath, String outPath) {
        File rootPathFile = new File(rootPath);
        if (!rootPathFile.exists()) {
            throw new RuntimeException("\u6e90\u7801\u751f\u6210\uff1a\u6a21\u7248\u8d44\u6e90\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff08" + rootPathFile + "\uff09");
        }
        String[] files = rootPathFile.list();
        boolean hasTemplate = false;
        boolean hasSource = false;
        for (String f : files) {
            if ("template".equals(f)) {
                hasTemplate = true;
            } else if ("manatee-code-source".equals(f) || "manatee-project-source".equals(f)) {
                hasSource = true;
            }
            if (hasTemplate && hasSource) break;
        }
        if (!hasSource) {
            throw new RuntimeException("\u6e90\u7801\u751f\u6210\uff1a\u6a21\u7248\u8d44\u6e90\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709manatee-source\u8d44\u6e90\uff08" + rootPathFile + "\uff09");
        }
        if (!hasTemplate) {
            throw new RuntimeException("\u6e90\u7801\u751f\u6210\uff1a\u6a21\u7248\u8d44\u6e90\u6587\u4ef6\u5939\u4e0b\u6ca1\u6709template\u8d44\u6e90\uff08" + rootPathFile + "\uff09");
        }
        System.out.println(rootPath);
        this.rootPath = rootPath;
        String templatePath = rootPath + "template";
        this.configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.templateDir = new File(templatePath);
        this.projectDirName = "manatee-project-source";
        this.partDirName = "manatee-part-source";
        this.projectName = "manatee-source-demo";
        this.outPath = outPath;
    }

    public void generateByProjectId(GenerateDTO dto) throws BizException {
        Long projectId = dto.getProjectId();
        if (null == projectId) {
            throw new BizException("\u8c03\u7528\u751f\u6210\u9879\u76ee\u6e90\u7801\u529f\u80fd\u7684\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.projectName = PinyinUtil.getPingYin(dto.getProjectName());
        if ("part".equals(dto.getGeneratorType())) {
            this.generatePartSource(dto);
        } else if ("project".equals(dto.getGeneratorType())) {
            this.generateProjectSource(dto);
        } else {
            throw new BizException("\u8c03\u7528\u751f\u6210\u9879\u76ee\u6e90\u7801\u529f\u80fdgeneratorType\u4e0d\u7b26\u5408\uff1a" + dto.getGeneratorType());
        }
    }

    private void generatePartSource(GenerateDTO dto) throws BizException {
        this.sourceDirPath = this.rootPath + this.partDirName;
        String outDirName = this.projectName + "-part";
        try {
            GenerationFileUtil.copyDir(this.sourceDirPath, this.outPath + outDirName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String packageName = dto.getPackageName();
        String projectName = outDirName;
        String projectDescribe = dto.getProjectDescribe();
        String applicationFileName = "ProjectApplication";
        String sourceRootPath = this.outPath + outDirName + "/src/main/java/";
        String packageRootPath = sourceRootPath + packageName.replace(".", "/") + "/";
        String controllerDir = packageRootPath + "controller";
        File controllerFile = new File(controllerDir);
        controllerFile.mkdirs();
        String serviceDir = packageRootPath + "service";
        File serviceFile = new File(serviceDir);
        serviceFile.mkdirs();
        String serviceImplDir = packageRootPath + "service/impl";
        File implFile = new File(serviceImplDir);
        implFile.mkdirs();
        HashMap<String, Object> baseMap = new HashMap<String, Object>();
        baseMap.putAll(GenerationConstant.STATIC_MAP);
        baseMap.put("package", packageName);
        baseMap.put("scanPackageManatee", "com.manatee");
        baseMap.put("scanPackageCustom", packageName.substring(0, packageName.lastIndexOf(".")));
        baseMap.put("projectName", projectName);
        baseMap.put("projectDescribe", projectDescribe);
        baseMap.put("applicationClassName", applicationFileName);
        List<PackageDTO> packageList = dto.getPackageList();
        TemplateUtils templateUtils = (TemplateUtils)SpringContextManager.getBean(TemplateUtils.class);
        for (PackageDTO packageDTO : packageList) {
            if (packageDTO.isModule().booleanValue() || !StringUtils.isNotEmpty((CharSequence)packageDTO.getTitle()) || CollUtil.isEmpty(packageDTO.getChildren())) continue;
            String className = PinyinUtil.getPingYin(packageDTO.getTitle());
            String upClassName = StringUtils.capitalize((String)className);
            baseMap.put("moduleName", packageDTO.getTitle());
            baseMap.put("upClassName", upClassName);
            baseMap.put("className", className);
            baseMap.put("date", DateUtils.formatDateTime((Date)new Date()));
            List<ModuleDTO> moduleList = this.getModuleList(packageDTO);
            if (CollUtil.isEmpty(moduleList)) continue;
            baseMap.put("moduleList", moduleList);
            this.generateControllerByTemplate(baseMap, packageRootPath + "controller/" + upClassName + "Controller.java");
            this.generateServiceByTemplate(baseMap, packageRootPath + "service/" + upClassName + "Service.java");
            this.creatServiceImpl(packageName, packageRootPath, templateUtils, upClassName, moduleList);
        }
    }

    private void generateProjectSource(GenerateDTO dto) throws BizException {
        this.sourceDirPath = this.rootPath + this.projectDirName;
        try {
            GenerationFileUtil.copyDir(this.sourceDirPath, this.outPath + this.projectName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String packageName = dto.getPackageName();
        String projectName = this.projectName;
        String projectDescribe = dto.getProjectDescribe();
        String applicationFileName = "ProjectApplication";
        String sourceRootPath = this.outPath + this.projectName + "/src/main/java/";
        String packageRootPath = sourceRootPath + packageName.replace(".", "/") + "/";
        String controllerDir = packageRootPath + "controller";
        File controllerFile = new File(controllerDir);
        controllerFile.mkdirs();
        String serviceDir = packageRootPath + "service";
        File serviceFile = new File(serviceDir);
        serviceFile.mkdirs();
        String serviceImplDir = packageRootPath + "service/impl";
        File implFile = new File(serviceImplDir);
        implFile.mkdirs();
        HashMap<String, Object> baseMap = new HashMap<String, Object>();
        baseMap.putAll(GenerationConstant.STATIC_MAP);
        baseMap.put("package", packageName);
        baseMap.put("scanPackageManatee", "com.manatee");
        baseMap.put("scanPackageCustom", packageName.substring(0, packageName.lastIndexOf(".")));
        baseMap.put("projectName", projectName);
        baseMap.put("projectDescribe", projectDescribe);
        baseMap.put("applicationClassName", applicationFileName);
        this.generateByTemplate(baseMap, "ProjectApplication.java.ftl", packageRootPath + applicationFileName + ".java");
        List packageList = dto.getPackageList();
        if (CollUtil.isEmpty(packageList)) {
            String devJsonStr = "[{\"children\":[{\"module\":{\"gmtModified\":\"2023-05-24 19:23:53\",\"code\":\"firstDemo\",\"modifiedUser\":161,\"moduleName\":\"\u7b2c\u4e00\u4e2a\u63a5\u53e3\",\"description\":\"\",\"conf\":\"{\\\"serviceMode\\\":[0],\\\"isUpload\\\":false}\",\"type\":1,\"systemVersion\":\"2.1\",\"valid\":0,\"isLogin\":1,\"moduleDescription\":\"\",\"moduleVersion\":\"1.0\",\"id\":168489581597581,\"requestMode\":\"GET\",\"titleIcon\":\"GET\",\"moduleCode\":\"firstDemo\",\"moduleType\":1,\"isHaveTest\":false,\"isPublished\":true,\"packageId\":959,\"sort\":1,\"env\":\"daily\",\"gmtCreate\":\"2023-05-24 10:36:56\",\"version\":\"1.0\",\"chartUrl\":\"https://manateeai.oss-cn-hangzhou.aliyuncs.com/manatee/image/327-firstDemo.png?time=1684927414917\",\"isUpdatedChart\":false,\"name\":\"\u7b2c\u4e00\u4e2a\u63a5\u53e3\",\"mock\":\"{}\",\"createUser\":161,\"projectId\":327,\"processConf\":\"{\\\"steps\\\":[{\\\"interruptLevel\\\":3,\\\"throwOuterExceptionFlag\\\":true,\\\"name\\\":\\\"paramCheck\\\",\\\"id\\\":\\\"0b390aac-b35c-449f-afc4-64f5081ac34e\\\",\\\"check\\\":[{\\\"checkName\\\":\\\"name\\\",\\\"checkType\\\":\\\"notBlank\\\",\\\"resultMsg\\\":\\\"\u53c2\u6570\u5f02\u5e38\\\"}],\\\"title\\\":\\\"\u53c2\u6570\u6821\u9a8c\\\"},{\\\"valueTo\\\":\\\"response\\\",\\\"handleType\\\":\\\"single\\\",\\\"name\\\":\\\"setData\\\",\\\"dataHandle\\\":\\\"name = \\\\\\\"\u5f20\u4e09\\\\\\\";id = 2;classname = name;classid = id;\\\",\\\"id\\\":\\\"7f7bcc13-febe-4fcb-9f58-ce2b5d938721\\\",\\\"title\\\":\\\"\u6d77\u725b\u6570\u636e\u5904\u7406\\\"}]}\"},\"title\":\"\u7b2c\u4e00\u4e2a\u63a5\u53e3\",\"isLeaf\":true,\"key\":168489581597581},{\"module\":{\"gmtModified\":\"2023-05-25 09:48:08\",\"code\":\"postDemo\",\"modifiedUser\":161,\"moduleName\":\"\u7b2c\u4e8c\u4e2a\u63a5\u53e3\",\"description\":\"\",\"conf\":\"{\\\"serviceMode\\\":[0]}\",\"type\":1,\"systemVersion\":\"2.1\",\"valid\":0,\"isLogin\":1,\"moduleDescription\":\"\",\"moduleVersion\":\"1.0\",\"id\":1684979236738623,\"requestMode\":\"POST\",\"titleIcon\":\"POST\",\"moduleCode\":\"postDemo\",\"moduleType\":1,\"isHaveTest\":false,\"isPublished\":true,\"packageId\":959,\"sort\":2,\"env\":\"daily\",\"gmtCreate\":\"2023-05-25 09:47:17\",\"version\":\"1.0\",\"chartUrl\":\"https://manateeai.oss-cn-hangzhou.aliyuncs.com/manatee/image/327-postDemo.png?time=1684979278244\",\"isUpdatedChart\":false,\"name\":\"\u7b2c\u4e8c\u4e2a\u63a5\u53e3\",\"mock\":\"{}\",\"createUser\":161,\"projectId\":327,\"processConf\":\"{\\\"steps\\\":[{\\\"valueTo\\\":\\\"response\\\",\\\"handleType\\\":\\\"single\\\",\\\"name\\\":\\\"setData\\\",\\\"dataHandle\\\":{\\\"data\\\":200},\\\"id\\\":\\\"4b7e80d0-ed10-45d3-a99b-3db3dd4bf31b\\\",\\\"title\\\":\\\"\u6d77\u725b\u6570\u636e\u5904\u7406\\\"}]}\"},\"title\":\"\u7b2c\u4e8c\u4e2a\u63a5\u53e3\",\"isLeaf\":true,\"key\":1684979236738623}],\"count\":2,\"title\":\"\u7b2c\u4e00\",\"key\":959,\"parentId\":0}]";
            String jsonStr = null != dto.getPackageListJsonString() ? dto.getPackageListJsonString() : devJsonStr;
            packageList = JSONArray.parseArray((String)jsonStr, PackageDTO.class);
        }
        TemplateUtils templateUtils = (TemplateUtils)SpringContextManager.getBean(TemplateUtils.class);
        for (PackageDTO packageDTO : packageList) {
            if (packageDTO.isModule().booleanValue() || !StringUtils.isNotEmpty((CharSequence)packageDTO.getTitle()) || CollUtil.isEmpty(packageDTO.getChildren())) continue;
            String className = PinyinUtil.getPingYin(packageDTO.getTitle());
            String upClassName = StringUtils.capitalize((String)className);
            baseMap.put("moduleName", packageDTO.getTitle());
            baseMap.put("upClassName", upClassName);
            baseMap.put("className", className);
            baseMap.put("date", DateUtils.formatDateTime((Date)new Date()));
            List<ModuleDTO> moduleList = this.getModuleList(packageDTO);
            if (CollUtil.isEmpty(moduleList)) continue;
            baseMap.put("moduleList", moduleList);
            this.generateControllerByTemplate(baseMap, packageRootPath + "controller/" + upClassName + "Controller.java");
            this.generateServiceByTemplate(baseMap, packageRootPath + "service/" + upClassName + "Service.java");
            this.creatServiceImpl(packageName, packageRootPath, templateUtils, upClassName, moduleList);
        }
    }

    private void creatServiceImpl(String packageName, String packageRootPath, TemplateUtils templateUtils, String upClassName, List<ModuleDTO> moduleList) throws BizException {
        GenerationProcessContentBuilder codeBuilder = GenerationProcessContentBuilderFactory.creat(upClassName, packageName);
        for (ModuleDTO moduleDTO : moduleList) {
            String processConf = moduleDTO.getProcessConf();
            String moduleCode = moduleDTO.getModuleCode();
            codeBuilder.setCurrentFunName(moduleCode);
            codeBuilder.addCode(new StringBuilder());
            List steps = ProcessDataSource.formatSteps((JSONObject)JSON.parseObject((String)processConf));
            for (Step step : steps) {
                String name = step.getName();
                BaseTemplate template = templateUtils.getTemplate(name);
                template.bulid(codeBuilder, step);
            }
        }
        codeBuilder.setToPath(packageRootPath + "service/impl/" + upClassName + "ServiceImpl.java");
        codeBuilder.build();
    }

    public String generateControllerByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/Controller.java.ftl", toFilePath);
    }

    public String generateServiceByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/Service.java.ftl", toFilePath);
    }

    private List<ModuleDTO> getModuleList(PackageDTO data) {
        ArrayList<ModuleDTO> moduleList = new ArrayList<ModuleDTO>();
        if (data.isModule().booleanValue()) {
            moduleList.add(data.getModule());
        }
        if (!data.isLeaf().booleanValue() && CollUtil.isNotEmpty(data.getChildren())) {
            for (PackageDTO child : data.getChildren()) {
                moduleList.addAll(this.getModuleList(child));
            }
        }
        return moduleList;
    }

    public String generateServiceImplByTemplate(Map<String, Object> objectMap, String toFilePath) {
        return this.generateByTemplate(objectMap, "java/ServiceImpl.java.ftl", toFilePath);
    }

    public String generateByTemplate(Map<String, Object> objectMap, String templateName, String toPath) {
        try {
            this.configuration.setDirectoryForTemplateLoading(this.templateDir);
            Template template = this.configuration.getTemplate(templateName);
            File toFile = new File(toPath);
            if (!toFile.exists()) {
                toFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(toFile);
            template.process(objectMap, (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").name()));
            fileOutputStream.close();
            System.out.println("\u6587\u4ef6[" + toPath + "]\u521b\u5efa\u6210\u529f");
            return toFile.getPath();
        }
        catch (Exception e) {
            this.LOGGER.error("generateByTemplate error ,templateName:\u3010{}\u3011, toPath:\u3010{}\u3011, objectMap:\u3010{}\u3011,e:{}", new Object[]{templateName, toPath, objectMap, e});
            return null;
        }
    }

    public Logger getLOGGER() {
        return this.LOGGER;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public String getSourceDirPath() {
        return this.sourceDirPath;
    }

    public String getOutPath() {
        return this.outPath;
    }

    public String getProjectDirName() {
        return this.projectDirName;
    }

    public String getPartDirName() {
        return this.partDirName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setLOGGER(Logger LOGGER) {
        this.LOGGER = LOGGER;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setTemplateDir(File templateDir) {
        this.templateDir = templateDir;
    }

    public void setSourceDirPath(String sourceDirPath) {
        this.sourceDirPath = sourceDirPath;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    public void setProjectDirName(String projectDirName) {
        this.projectDirName = projectDirName;
    }

    public void setPartDirName(String partDirName) {
        this.partDirName = partDirName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceGenerator)) {
            return false;
        }
        SourceGenerator other = (SourceGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$LOGGER = this.getLOGGER();
        Logger other$LOGGER = other.getLOGGER();
        if (this$LOGGER == null ? other$LOGGER != null : !this$LOGGER.equals(other$LOGGER)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        File this$templateDir = this.getTemplateDir();
        File other$templateDir = other.getTemplateDir();
        if (this$templateDir == null ? other$templateDir != null : !((Object)this$templateDir).equals(other$templateDir)) {
            return false;
        }
        String this$sourceDirPath = this.getSourceDirPath();
        String other$sourceDirPath = other.getSourceDirPath();
        if (this$sourceDirPath == null ? other$sourceDirPath != null : !this$sourceDirPath.equals(other$sourceDirPath)) {
            return false;
        }
        String this$outPath = this.getOutPath();
        String other$outPath = other.getOutPath();
        if (this$outPath == null ? other$outPath != null : !this$outPath.equals(other$outPath)) {
            return false;
        }
        String this$projectDirName = this.getProjectDirName();
        String other$projectDirName = other.getProjectDirName();
        if (this$projectDirName == null ? other$projectDirName != null : !this$projectDirName.equals(other$projectDirName)) {
            return false;
        }
        String this$partDirName = this.getPartDirName();
        String other$partDirName = other.getPartDirName();
        if (this$partDirName == null ? other$partDirName != null : !this$partDirName.equals(other$partDirName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        return !(this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $LOGGER = this.getLOGGER();
        result = result * 59 + ($LOGGER == null ? 43 : $LOGGER.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        File $templateDir = this.getTemplateDir();
        result = result * 59 + ($templateDir == null ? 43 : ((Object)$templateDir).hashCode());
        String $sourceDirPath = this.getSourceDirPath();
        result = result * 59 + ($sourceDirPath == null ? 43 : $sourceDirPath.hashCode());
        String $outPath = this.getOutPath();
        result = result * 59 + ($outPath == null ? 43 : $outPath.hashCode());
        String $projectDirName = this.getProjectDirName();
        result = result * 59 + ($projectDirName == null ? 43 : $projectDirName.hashCode());
        String $partDirName = this.getPartDirName();
        result = result * 59 + ($partDirName == null ? 43 : $partDirName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        return result;
    }

    public String toString() {
        return "SourceGenerator(LOGGER=" + this.getLOGGER() + ", configuration=" + this.getConfiguration() + ", templateDir=" + this.getTemplateDir() + ", sourceDirPath=" + this.getSourceDirPath() + ", outPath=" + this.getOutPath() + ", projectDirName=" + this.getProjectDirName() + ", partDirName=" + this.getPartDirName() + ", projectName=" + this.getProjectName() + ", rootPath=" + this.getRootPath() + ")";
    }
}

