/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.time;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.date.DateUtil;
import com.manatee.fun.AbstractFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.impl.system.ThrowsExceptionProcess;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeAddFun
extends AbstractFunction {
    protected static Logger LOGGER = LoggerFactory.getLogger(TimeAddFun.class);

    public String getName() {
        return "timeAdd";
    }

    public Object doFunction(FunctionContent content) {
        this.checkParamSize(content);
        if (!this.checkParamExist(content).booleanValue()) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object obj1 = content.getParameter(0);
        Object obj2 = content.getParameter(1);
        Object obj3 = content.getParameter(2);
        Object date = obj1.toString().contains("-") || obj1.toString().contains(":") ? DateUtil.parse((CharSequence)obj1.toString()) : (Pattern.compile("[0-9]*").matcher(obj1.toString()).matches() ? new Date(Long.parseLong(obj1.toString())) : (Date)obj1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)date);
        String addType = obj2.toString().toLowerCase();
        int num = 0;
        try {
            num = (Integer)obj3;
        }
        catch (Exception e) {
            this.errorLog("param_is_error", "param_is_error", "timeAdd\u51fd\u6570\u53c2\u6570\u9519\u8bef,\u8bf7\u586b\u5199\u6574\u6570\u7c7b\u578b\u6570\u503c", 400, content);
        }
        switch (addType) {
            case "year": {
                calendar.add(1, num);
                break;
            }
            case "month": {
                calendar.add(2, num);
                break;
            }
            case "week": {
                calendar.add(3, num);
                break;
            }
            case "day": {
                calendar.add(5, num);
                break;
            }
            case "hour": {
                calendar.add(11, num);
                break;
            }
            case "minute": {
                calendar.add(12, num);
                break;
            }
            case "second": {
                calendar.add(13, num);
                break;
            }
            default: {
                this.errorLog("param_is_error", "param_is_error", "timeAdd\u51fd\u6570\u53c2\u6570\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", 400, content);
            }
        }
        Date time = calendar.getTime();
        return sdf.format(time);
    }

    public Integer getMinParamSize() {
        return 3;
    }

    public Integer getMaxParamSize() {
        return 3;
    }

    private void errorLog(String code, String subCode, String msg, int status, FunctionContent content) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)code);
        jsonObject.put("resultSubCode", (Object)subCode);
        jsonObject.put("resultMsg", (Object)msg);
        jsonObject.put("resultStatus", (Object)status);
        BizException bizException = ThrowsExceptionProcess.getException((JSONObject)jsonObject, (ProcessContent)content);
        throw new RuntimeException((Throwable)bizException);
    }
}

