/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.memcached.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import javax.annotation.Resource;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MemcacheKeyValueQueryProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(MemcacheKeyValueQueryProcess.class);
    @Resource
    private MemcachedClient memcachedClient;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key"});
        String objectKey = this.variableUtil.calVarInConf(content, "key");
        try {
            Object result = this.memcachedClient.get(objectKey);
            this.outputUtil.handleAndPutData(content, result);
        }
        catch (Exception e) {
            this.LOGGER.error("Memcache \u83b7\u53d6value\u5931\u8d25\uff0ckey:\u3010{}\u3011", (Object)objectKey, (Object)e);
        }
    }

    public String getName() {
        return "memcacheKeyValueQuery";
    }
}

