/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.sql;

import com.manatee.common.util.tool.core.builder.Builder;
import com.manatee.common.util.tool.core.collection.CollectionUtil;
import com.manatee.common.util.tool.core.collection.IterUtil;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.DbRuntimeException;
import com.manatee.lowcodedb.newdb.dialect.DialectName;
import com.manatee.lowcodedb.newdb.dialect.impl.OracleDialect;
import com.manatee.lowcodedb.newdb.sql.Condition;
import com.manatee.lowcodedb.newdb.sql.ConditionBuilder;
import com.manatee.lowcodedb.newdb.sql.DBQuery;
import com.manatee.lowcodedb.newdb.sql.Direction;
import com.manatee.lowcodedb.newdb.sql.Order;
import com.manatee.lowcodedb.newdb.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SqlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        return new SqlBuilder(wrapper);
    }

    public static SqlBuilder of(CharSequence sql) {
        return SqlBuilder.create().append(sql);
    }

    public static void validateEntity(DbEntity entity) throws DbRuntimeException {
        if (null == entity) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank((CharSequence)entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public SqlBuilder() {
    }

    public SqlBuilder(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public SqlBuilder insert(DbEntity entity) {
        return this.insert(entity, DialectName.ANSI);
    }

    public SqlBuilder insert(DbEntity entity, DialectName dialectName) {
        return this.insert(entity, dialectName.name());
    }

    public SqlBuilder insert(DbEntity entity, String dialectName) {
        SqlBuilder.validateEntity(entity);
        boolean isOracle = DialectName.ORACLE.match(dialectName);
        boolean isDameng = DialectName.DAMENG.match(dialectName);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            fieldsPart.append(null != this.wrapper ? this.wrapper.wrap(field) : field);
            if ((isOracle || isDameng) && OracleDialect.isNextVal(value)) {
                placeHolder.append(value);
                continue;
            }
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        if (DialectName.PHOENIX.match(dialectName)) {
            this.sql.append("UPSERT INTO ");
        } else if (entity.getInsertTypeEnum() == InsertTypeEnum.REPLACE) {
            this.sql.append("REPLACE INTO ");
        } else if (entity.getInsertTypeEnum() == InsertTypeEnum.IGNORE) {
            this.sql.append("INSERT IGNORE INTO ");
        } else {
            this.sql.append("INSERT INTO ");
        }
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        this.sql.append(tableName).append(" (").append((CharSequence)fieldsPart).append(") VALUES (").append((CharSequence)placeHolder).append(")");
        return this;
    }

    public SqlBuilder insertForDameng(DbEntity entity) {
        SqlBuilder.validateEntity(entity);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            fieldsPart.append(null != this.wrapper ? this.wrapper.wrap(field) : field);
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        String pk = entity.getPk();
        this.sql.append("MERGE INTO ");
        String keySet = IterUtil.join((Iterable)entity.keySet(), (CharSequence)",", (String)"\"", (String)"\"");
        String valueSet = IterUtil.join((Iterable)entity.keySet(), (CharSequence)",", (String)"b.\"", (String)"\"");
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        this.sql.append(tableName).append(" a USING ( SELECT ").append(keySet).append(" FROM ( SELECT ");
        int size = entity.size();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            if (--size <= 0) {
                this.sql.append("? AS ").append(this.wrapper.wrap((String)stringObjectEntry.getKey()));
                continue;
            }
            this.sql.append("? AS ").append(this.wrapper.wrap((String)stringObjectEntry.getKey())).append(",");
        }
        pk = this.wrapper.wrap(pk);
        this.sql.append(" FROM dual ) tmp ) b ON ( a.").append(pk).append(" = b.").append(pk);
        if (entity.getInsertTypeEnum() == InsertTypeEnum.REPLACE) {
            this.sql.append(") WHEN MATCHED THEN UPDATE SET ");
            for (Map.Entry stringObjectEntry : entity.entrySet()) {
                String key = (String)stringObjectEntry.getKey();
                if (pk.equals(key = this.wrapper.wrap(key))) continue;
                this.sql.append("a.").append(key).append(" = ").append("b.").append(key).append(",");
            }
            this.sql.delete(this.sql.length() - 1, this.sql.length());
            this.sql.append(" WHEN NOT MATCHED THEN INSERT (").append(keySet).append(") VALUES (").append(valueSet).append(")");
            return this;
        }
        this.sql.append(") WHEN NOT MATCHED THEN INSERT (").append(keySet).append(") VALUES (").append(valueSet).append(")");
        return this;
    }

    public SqlBuilder insertForSqlServer(DbEntity entity) {
        SqlBuilder.validateEntity(entity);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            String field = (String)stringObjectEntry.getKey();
            Object value = stringObjectEntry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (fieldsPart.length() > 0) {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            fieldsPart.append(null != this.wrapper ? this.wrapper.wrap(field) : field);
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        String pk = entity.getPk();
        this.sql.append("MERGE INTO ");
        String keySet = IterUtil.join((Iterable)entity.keySet(), (CharSequence)",", (String)"\"", (String)"\"");
        String valueSet = IterUtil.join((Iterable)entity.keySet(), (CharSequence)",", (String)"b.\"", (String)"\"");
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        this.sql.append(tableName).append(" a USING ( SELECT ");
        int size = entity.size();
        for (Map.Entry stringObjectEntry : entity.entrySet()) {
            if (--size <= 0) {
                this.sql.append("? AS ").append(this.wrapper.wrap((String)stringObjectEntry.getKey()));
                continue;
            }
            this.sql.append("? AS ").append(this.wrapper.wrap((String)stringObjectEntry.getKey())).append(",");
        }
        pk = this.wrapper.wrap(pk);
        this.sql.append(" ) b ON ( a.").append(pk).append(" = b.").append(pk);
        if (entity.getInsertTypeEnum() == InsertTypeEnum.REPLACE) {
            this.sql.append(") WHEN MATCHED THEN UPDATE SET ");
            for (Map.Entry stringObjectEntry : entity.entrySet()) {
                String key = (String)stringObjectEntry.getKey();
                if (pk.equals(key = this.wrapper.wrap(key))) continue;
                this.sql.append("a.").append(key).append(" = ").append("b.").append(key).append(",");
            }
            this.sql.delete(this.sql.length() - 1, this.sql.length());
            this.sql.append(" WHEN NOT MATCHED THEN INSERT (").append(keySet).append(") VALUES (").append(valueSet).append(");");
            return this;
        }
        this.sql.append(") WHEN NOT MATCHED THEN INSERT (").append(keySet).append(") VALUES (").append(valueSet).append(");");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(DbEntity entity) {
        SqlBuilder.validateEntity(entity);
        String tableName = entity.getTableName();
        if (null != this.wrapper) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        this.sql.append("UPDATE ").append(tableName).append(" SET ");
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                if (this.paramValues.size() > 0) {
                    this.sql.append(", ");
                }
                this.sql.append(null != this.wrapper ? this.wrapper.wrap((String)field) : field).append(" = ? ");
                this.paramValues.add(value);
            }
        });
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionUtil.join(fields, (CharSequence)","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (ArrayUtil.isEmpty((Object[])tableNames) || StrUtil.hasBlank((CharSequence[])tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.wrapper) {
            tableNames = this.wrapper.wrapTable(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayUtil.join((Object[])tableNames, (CharSequence)","));
        return this;
    }

    public SqlBuilder where(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.where(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder where(String where) {
        if (StrUtil.isNotBlank((CharSequence)where)) {
            this.sql.append(" WHERE ").append(where);
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.wrapper.wrap(field)).append(" IN ").append("(").append(ArrayUtil.join((Object[])values, (CharSequence)",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayUtil.join((Object[])fields, (CharSequence)","));
        }
        return this;
    }

    public SqlBuilder having(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.having(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder having(String having) {
        if (StrUtil.isNotBlank((CharSequence)having)) {
            this.sql.append(" HAVING ").append(having);
        }
        return this;
    }

    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayUtil.isEmpty((Object[])orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        boolean isFirst = true;
        for (Order order : orders) {
            String field = order.getField();
            if (null != this.wrapper) {
                field = this.wrapper.wrap(field);
            }
            if (StrUtil.isBlank((CharSequence)field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (null == direction) continue;
            this.sql.append(" ").append((Object)direction);
        }
        return this;
    }

    public SqlBuilder join(String tableName, JoinTypeEnum join) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join).append(" JOIN ");
            if (null != this.wrapper) {
                tableName = this.wrapper.wrapTable(tableName);
            }
            this.sql.append(tableName);
        }
        return this;
    }

    public SqlBuilder on(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.on(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder on(String firstTableName, String tableName, Condition ... conditions) {
        if (StrUtil.isNotBlank((CharSequence)firstTableName)) {
            // empty if block
        }
        return this;
    }

    public SqlBuilder on(String on) {
        if (StrUtil.isNotBlank((CharSequence)on)) {
            this.sql.append(" ON ").append(on);
        }
        return this;
    }

    public SqlBuilder insertPreFragment(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.insert(0, sqlFragment);
        }
        return this;
    }

    public SqlBuilder append(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.append(sqlFragment);
        }
        return this;
    }

    public SqlBuilder addParams(Object ... params) {
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            Collections.addAll(this.paramValues, params);
        }
        return this;
    }

    public SqlBuilder query(DBQuery query) {
        return this.select(query.getFields()).from(query.getTableNames()).where(query.getWhere());
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[0]);
    }

    public String build() {
        return this.sql.toString();
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(Condition ... conditions) {
        if (ArrayUtil.isEmpty((Object[])conditions)) {
            return "";
        }
        if (null != this.wrapper) {
            conditions = this.wrapper.wrap(conditions);
        }
        return ConditionBuilder.of(conditions).build(this.paramValues);
    }

    private String buildJoinCondition(String firstTableName, String tableName, Condition ... conditions) {
        if (ArrayUtil.isEmpty((Object[])conditions)) {
            return "";
        }
        if (StrUtil.isNotBlank((CharSequence)tableName)) {
            tableName = this.wrapper.wrapTable(tableName);
        }
        if (StrUtil.isNotBlank((CharSequence)firstTableName)) {
            firstTableName = this.wrapper.wrapTable(firstTableName);
        }
        if (null != this.wrapper) {
            conditions = this.wrapper.wrap(conditions);
        }
        return ConditionBuilder.of(conditions).build();
    }

    public static enum InsertTypeEnum {
        INSERT,
        REPLACE,
        IGNORE;


        public static InsertTypeEnum valueOfString(String insertType) {
            if (StrUtil.isBlank((CharSequence)insertType)) {
                return INSERT;
            }
            if (StrUtil.equalsIgnoreCase((CharSequence)insertType, (CharSequence)"INSERT") || StrUtil.equalsIgnoreCase((CharSequence)insertType, (CharSequence)"error")) {
                return INSERT;
            }
            if (StrUtil.equalsIgnoreCase((CharSequence)insertType, (CharSequence)"REPLACE")) {
                return REPLACE;
            }
            if (StrUtil.equalsIgnoreCase((CharSequence)insertType, (CharSequence)"IGNORE")) {
                return IGNORE;
            }
            return INSERT;
        }
    }

    public static enum JoinTypeEnum {
        INNER,
        LEFT,
        RIGHT,
        FULL;


        public static JoinTypeEnum valueOfString(String joinType) {
            if (StrUtil.isBlank((CharSequence)joinType)) {
                return INNER;
            }
            String lowerCase = joinType.toLowerCase();
            if (StrUtil.equals((CharSequence)lowerCase, (CharSequence)"inner join") || StrUtil.equals((CharSequence)lowerCase, (CharSequence)"inner")) {
                return INNER;
            }
            if (StrUtil.equals((CharSequence)lowerCase, (CharSequence)"left join") || StrUtil.equals((CharSequence)lowerCase, (CharSequence)"left")) {
                return LEFT;
            }
            if (StrUtil.equals((CharSequence)lowerCase, (CharSequence)"right join") || StrUtil.equals((CharSequence)lowerCase, (CharSequence)"right")) {
                return RIGHT;
            }
            if (StrUtil.equals((CharSequence)lowerCase, (CharSequence)"full join") || StrUtil.equals((CharSequence)lowerCase, (CharSequence)"full")) {
                return RIGHT;
            }
            return INNER;
        }
    }
}

