/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.newdb.handler;

import com.manatee.common.domain.DBQuery;
import com.manatee.common.util.CamelCaseUtil;
import com.manatee.common.util.tool.core.bean.BeanUtil;
import com.manatee.common.util.tool.core.bean.PropDesc;
import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.ReflectUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.core.util.TypeUtil;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.sql.Join;
import com.manatee.lowcodedb.newdb.sql.JoinQueryField;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandleHelper {
    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, T bean) throws SQLException {
        return (T)HandleHelper.handleRow(columnCount, meta, rs).toBeanIgnoreCase(bean);
    }

    public static <T> T handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, Class<T> beanClass) throws SQLException {
        Assert.notNull(beanClass, (String)"Bean Class must be not null !", (Object[])new Object[0]);
        if (beanClass.isArray()) {
            Class<?> componentType = beanClass.getComponentType();
            Object[] result = ArrayUtil.newArray(componentType, (int)columnCount);
            int i = 0;
            int j = 1;
            while (i < columnCount) {
                result[i] = HandleHelper.getColumnValue(rs, j, meta.getColumnType(j), componentType);
                ++i;
                ++j;
            }
            return (T)result;
        }
        if (Iterable.class.isAssignableFrom(beanClass)) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return (T)Convert.convert(beanClass, (Object)objRow);
        }
        if (beanClass.isAssignableFrom(DbEntity.class)) {
            return (T)((Object)HandleHelper.handleRow(columnCount, meta, rs));
        }
        if (String.class == beanClass) {
            Object[] objRow = HandleHelper.handleRow(columnCount, meta, rs, Object[].class);
            return (T)StrUtil.join((CharSequence)", ", (Object[])objRow);
        }
        Object bean = ReflectUtil.newInstanceIfPossible(beanClass);
        Map propMap = BeanUtil.getBeanDesc(beanClass).getPropMap(true);
        for (int i = 1; i <= columnCount; ++i) {
            Method setter;
            String columnLabel = meta.getColumnLabel(i);
            PropDesc pd = (PropDesc)propMap.get(columnLabel);
            if (null == pd) {
                pd = (PropDesc)propMap.get(StrUtil.toCamelCase((CharSequence)columnLabel));
            }
            Method method = setter = null == pd ? null : pd.getSetter();
            if (null == setter) continue;
            Object value = HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), TypeUtil.getFirstParamType((Method)setter));
            ReflectUtil.invokeWithCheck((Object)bean, (Method)setter, (Object[])new Object[]{value});
        }
        return (T)bean;
    }

    public static DbEntity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        return HandleHelper.handleRow(columnCount, meta, rs, false);
    }

    public static DbEntity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, boolean caseInsensitive) throws SQLException {
        return HandleHelper.handleRow(new DbEntity(null, caseInsensitive), columnCount, meta, rs, true);
    }

    public static DbEntity handleRow(int columnCount, ResultSetMetaData meta, ResultSet rs, boolean caseInsensitive, boolean camelCase, String upperOrLowerCase) throws SQLException {
        return HandleHelper.handleRow(new DbEntity(null, caseInsensitive), columnCount, meta, rs, true, camelCase, upperOrLowerCase);
    }

    public static <T extends DbEntity> T handleRow(T row, int columnCount, ResultSetMetaData meta, ResultSet rs, boolean withMetaInfo, boolean camelCase, String upperOrLowerCase) throws SQLException {
        for (int i = 1; i <= columnCount; ++i) {
            int type = meta.getColumnType(i);
            String columnLabel = meta.getColumnLabel(i);
            if ("rownum_".equalsIgnoreCase(columnLabel)) continue;
            columnLabel = HandleHelper.handleUpperOrLowerCase(columnLabel, upperOrLowerCase);
            if (camelCase) {
                columnLabel = CamelCaseUtil.camelCase((String)columnLabel);
            }
            row.put(columnLabel, HandleHelper.getColumnValue(rs, i, type, null));
        }
        if (withMetaInfo) {
            try {
                row.setTableName(meta.getTableName(1));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            row.setFieldNames(row.keySet());
        }
        return row;
    }

    public static String handleUpperOrLowerCase(String columnLabel, String upperOrLowerCase) {
        if (!"none".equals(upperOrLowerCase)) {
            if ("lowerCase".equals(upperOrLowerCase)) {
                columnLabel = columnLabel.toLowerCase();
                return columnLabel;
            }
            if ("upperCase".equals(upperOrLowerCase)) {
                columnLabel = columnLabel.toUpperCase();
                return columnLabel;
            }
        }
        return columnLabel;
    }

    public static String handleUpperOrLowerCase(String columnLabel, String upperOrLowerCase, Boolean camelCase) {
        if (!"none".equals(upperOrLowerCase)) {
            if ("lowerCase".equals(upperOrLowerCase)) {
                columnLabel = columnLabel.toLowerCase();
            } else if ("upperCase".equals(upperOrLowerCase)) {
                columnLabel = columnLabel.toUpperCase();
            }
        }
        if (camelCase.booleanValue() && columnLabel.contains("_")) {
            columnLabel = CamelCaseUtil.camelCase((String)columnLabel);
        }
        return columnLabel;
    }

    public static <T extends DbEntity> T handleRow(T row, int columnCount, ResultSetMetaData meta, ResultSet rs, boolean withMetaInfo) throws SQLException {
        return HandleHelper.handleRow(row, columnCount, meta, rs, withMetaInfo, true, "none");
    }

    public static DbEntity handleRow(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        return HandleHelper.handleRow(columnCount, meta, rs);
    }

    public static List<Object> handleRowToList(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            row.add(HandleHelper.getColumnValue(rs, i, meta.getColumnType(i), null));
        }
        return row;
    }

    public static <T extends Collection<DbEntity>> T handleRs(ResultSet rs, T collection) throws SQLException {
        return HandleHelper.handleRs(rs, collection, false);
    }

    public static <T extends Collection<DbEntity>> T handleRs(ResultSet rs, T collection, boolean caseInsensitive, boolean camelCase, String upperOrLowerCase) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add((DbEntity)HandleHelper.handleRow(columnCount, meta, rs, caseInsensitive, camelCase, upperOrLowerCase));
        }
        return collection;
    }

    public static <T extends Collection<DbEntity>> T handleRs(ResultSet rs, T collection, boolean caseInsensitive) throws SQLException {
        return HandleHelper.handleRs(rs, collection, caseInsensitive, true, "node");
    }

    public static <E, T extends Collection<E>> T handleRsToBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add(HandleHelper.handleRow(columnCount, meta, rs, elementBeanType));
        }
        return collection;
    }

    private static Object getColumnValue(ResultSet rs, int columnIndex, int type, Type targetColumnType) throws SQLException {
        Object rawValue = null;
        switch (type) {
            case 93: {
                try {
                    rawValue = rs.getTimestamp(columnIndex);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 92: {
                rawValue = rs.getTime(columnIndex);
                break;
            }
            case 2005: {
                rawValue = rs.getString(columnIndex);
                break;
            }
            default: {
                rawValue = rs.getObject(columnIndex);
            }
        }
        if (null == targetColumnType || Object.class == targetColumnType) {
            return rawValue;
        }
        return Convert.convert((Type)targetColumnType, (Object)rawValue);
    }

    public static void joinQueryFieldToObject(Join join, DBQuery query, DbEntity dbEntity) {
        String returnObjName = join.getJoinReturnObjName();
        HashMap<String, Object> joinQueryData = new HashMap<String, Object>(join.getJoinQueryFields().size());
        for (JoinQueryField joinQueryField : join.getJoinQueryFields()) {
            String asQueryField = HandleHelper.handleUpperOrLowerCase(joinQueryField.getAsQueryField(), query.getUpperOrLowerCase(), query.getCamelCase());
            String originalQueryField = HandleHelper.handleUpperOrLowerCase(joinQueryField.getOriginalQueryField(), query.getUpperOrLowerCase(), query.getCamelCase());
            joinQueryData.put(originalQueryField, dbEntity.get(asQueryField));
            dbEntity.remove(asQueryField);
        }
        dbEntity.set(returnObjName, joinQueryData);
    }
}

