/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.dfa;

import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.lang.Filter;
import com.manatee.common.util.tool.core.thread.ThreadUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.dfa.FoundWord;
import com.manatee.common.util.tool.dfa.SensitiveProcessor;
import com.manatee.common.util.tool.dfa.WordTree;
import com.manatee.common.util.tool.json.JSONUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class SensitiveUtil {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final WordTree sensitiveTree = new WordTree();

    public static boolean isInited() {
        return false == sensitiveTree.isEmpty();
    }

    public static void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                SensitiveUtil.init(sensitiveWords);
                return true;
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(StrUtil.split((CharSequence)sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, ',', isAsync);
    }

    public static void setCharFilter(Filter<Character> charFilter) {
        if (charFilter != null) {
            sensitiveTree.setCharFilter(charFilter);
        }
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object obj) {
        return sensitiveTree.isMatch(JSONUtil.toJsonStr(obj));
    }

    @Deprecated
    public static String getFindedFirstSensitive(String text) {
        return sensitiveTree.match(text);
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        return sensitiveTree.matchWord(text);
    }

    @Deprecated
    public static String getFindedFirstSensitive(Object obj) {
        return sensitiveTree.match(JSONUtil.toJsonStr(obj));
    }

    public static FoundWord getFoundFirstSensitive(Object obj) {
        return sensitiveTree.matchWord(JSONUtil.toJsonStr(obj));
    }

    @Deprecated
    public static List<String> getFindedAllSensitive(String text) {
        return sensitiveTree.matchAll(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        return sensitiveTree.matchAllWords(text);
    }

    @Deprecated
    public static List<String> getFindedAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAll(text, -1, isDensityMatch, isGreedMatch);
    }

    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    @Deprecated
    public static List<String> getFindedAllSensitive(Object bean) {
        return sensitiveTree.matchAll(JSONUtil.toJsonStr(bean));
    }

    public static List<FoundWord> getFoundAllSensitive(Object bean) {
        return sensitiveTree.matchAllWords(JSONUtil.toJsonStr(bean));
    }

    @Deprecated
    public static List<String> getFindedAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAll(JSONUtil.toJsonStr(bean), -1, isDensityMatch, isGreedMatch);
    }

    public static List<FoundWord> getFoundAllSensitive(Object bean, boolean isDensityMatch, boolean isGreedMatch) {
        return SensitiveUtil.getFoundAllSensitive(JSONUtil.toJsonStr(bean), isDensityMatch, isGreedMatch);
    }

    public static <T> T sensitiveFilter(T bean, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        String jsonText = JSONUtil.toJsonStr(bean);
        Class<?> c = bean.getClass();
        return (T)JSONUtil.toBean(SensitiveUtil.sensitiveFilter(jsonText, isGreedMatch, sensitiveProcessor), c);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StrUtil.isEmpty(text)) {
            return text;
        }
        List<FoundWord> foundWordList = SensitiveUtil.getFoundAllSensitive(text, false, isGreedMatch);
        if (CollUtil.isEmpty(foundWordList)) {
            return text;
        }
        sensitiveProcessor = sensitiveProcessor == null ? new SensitiveProcessor(){} : sensitiveProcessor;
        HashMap foundWordMap = new HashMap(foundWordList.size());
        foundWordList.forEach(foundWord -> foundWordMap.put(foundWord.getStartIndex(), foundWord));
        int length = text.length();
        StringBuilder textStringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            FoundWord fw = (FoundWord)foundWordMap.get(i);
            if (fw != null) {
                textStringBuilder.append(sensitiveProcessor.process(fw));
                i = (Integer)fw.getEndIndex();
                continue;
            }
            textStringBuilder.append(text.charAt(i));
        }
        return textStringBuilder.toString();
    }
}

