/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.mongo.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.mongo.MongoReadUtil;
import com.manatee.mongo.MongoWriteUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MongoUpdateProcess
implements IProcess {
    @Resource
    private IInputUtil inputUtil;
    @Resource
    private MongoWriteUtil mongoWriteUtil;
    @Resource
    private MongoReadUtil mongoReadUtil;
    @Resource
    private IProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        JSONObject conf = content.getStepConf();
        this.processConfUtil.checkConf(content, new String[]{"table"});
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)this.updateData(content, conf));
    }

    public Long updateData(ProcessContent content, JSONObject conf) throws BizException {
        String db = this.variableUtil.calVarInConf(content, "db");
        String table = conf.getString("table");
        Map queryParam = this.inputUtil.getHandleObject(content, "queryParams");
        if (queryParam == null || queryParam.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "input_db_query_is_null");
        }
        Map outputParam = this.inputUtil.getHandleObject(content, "updateParams");
        if (outputParam == null || outputParam.size() == 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "update_data_is_null");
        }
        DBQuery dbQuery = new DBQuery();
        dbQuery.setDb(db);
        dbQuery.setTable(table);
        dbQuery.setConditionMap(queryParam);
        JSON haveValue = this.mongoReadUtil.find(dbQuery);
        if (MongoUpdateProcess.isNull(haveValue) && conf.getString("upsert").equals("yes")) {
            queryParam.putAll(outputParam);
            this.mongoWriteUtil.insert(db, table, queryParam);
            return 1L;
        }
        return this.mongoWriteUtil.update(db, table, queryParam, outputParam);
    }

    private static boolean isNull(Object haveValue) {
        JSONArray array;
        Map value;
        if (haveValue == null) {
            return true;
        }
        if (haveValue instanceof Map && (value = (Map)haveValue).size() == 0) {
            return true;
        }
        if (haveValue instanceof JSONArray && (array = (JSONArray)haveValue).size() == 0) {
            return true;
        }
        return haveValue instanceof JSONObject && (value = (JSONObject)haveValue).size() == 0;
    }

    public String getName() {
        return "mongoUpdate";
    }

    public static void main(String[] args) {
    }
}

