/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.annotations.ManateeParams;
import com.manatee.annotations.ManateeProcess;
import com.manatee.annotations.ManateeService;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.BooleanUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ManateeService
public class CamundaGetTaskPropertiesProcess {
    private static final Logger log = LoggerFactory.getLogger(CamundaGetTaskPropertiesProcess.class);
    @Resource
    private TaskService taskService;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private HistoryService historyService;
    @Resource
    private ManateeTaskService manateeTaskService;

    @ManateeProcess(name="\u67e5\u8be2\u7528\u6237\u4efb\u52a1\u6269\u5c55\u5c5e\u6027", code="camundaGetTaskPropertiesProcess")
    public JSONObject getUserTaskExtProperties(@ManateeParams(value="taskId") String taskId, @ManateeParams(value="isGlobal") Boolean isGlobal) throws BizException {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        HistoricTaskInstance historicTaskInstance = null;
        if (task == null) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
            if (historicTaskInstance == null) {
                return new JSONObject();
            }
            processDefinitionId = historicTaskInstance.getProcessDefinitionId();
            taskDefinitionKey = this.manateeTaskService.getActivityId(historicTaskInstance.getTaskDefinitionKey());
        } else {
            if (task.getProcessDefinitionId() == null) {
                return new JSONObject();
            }
            processDefinitionId = task.getProcessDefinitionId();
            taskDefinitionKey = this.manateeTaskService.getActivityId(task.getTaskDefinitionKey());
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        JSONObject globalResult = new JSONObject();
        Collection processCollection = bpmnModelInstance.getModelElementsByType(Process.class);
        if (processCollection != null) {
            for (Process process : processCollection) {
                Collection properties;
                ExtensionElements extensionElements = process.getExtensionElements();
                if (extensionElements == null || !CollUtil.isNotEmpty((Collection)extensionElements.getElements()) || !CollUtil.isNotEmpty((Collection)(properties = ((CamundaProperties)extensionElements.getElementsQuery().filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) continue;
                for (CamundaProperty property : properties) {
                    String name = property.getCamundaName();
                    String value = property.getCamundaValue();
                    globalResult.put(name, (Object)value);
                }
            }
        }
        JSONObject result = new JSONObject();
        ModelElementInstance modelElement = bpmnModelInstance.getModelElementById(taskDefinitionKey);
        if (modelElement != null && modelElement instanceof UserTask) {
            Collection camundaProperties;
            Query elementsQuery;
            Map variables;
            if (task != null) {
                try {
                    variables = this.taskService.getVariables(taskId);
                    if (variables != null) {
                        result.putAll(variables);
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u53d8\u91cf\u5f02\u5e38\uff1a", (Throwable)e);
                }
            } else {
                try {
                    variables = this.runtimeService.getVariables(historicTaskInstance.getExecutionId());
                    if (variables != null) {
                        result.putAll(variables);
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u53d8\u91cf\u5f02\u5e38\uff1a", (Throwable)e);
                    List historicVariableInstanceList = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).list();
                    historicVariableInstanceList.forEach(historicVariableInstance -> {
                        if (historicVariableInstance.getTaskId() == null) {
                            result.put(historicVariableInstance.getName(), historicVariableInstance.getValue());
                        }
                        if (historicVariableInstance.getTaskId() != null && historicVariableInstance.getTaskId().equals(taskId)) {
                            result.put(historicVariableInstance.getName(), historicVariableInstance.getValue());
                        }
                    });
                }
            }
            UserTask userTask = (UserTask)modelElement;
            ExtensionElements extensionElements = userTask.getExtensionElements();
            if (extensionElements != null && (elementsQuery = extensionElements.getElementsQuery()) != null && CollUtil.isNotEmpty((Collection)(camundaProperties = ((CamundaProperties)elementsQuery.filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) {
                for (CamundaProperty camundaProperty : camundaProperties) {
                    result.put(camundaProperty.getCamundaName(), (Object)camundaProperty.getCamundaValue());
                }
            }
        }
        if (BooleanUtil.isTrue((Boolean)isGlobal)) {
            result.putAll((Map)globalResult);
            return result;
        }
        globalResult.putAll((Map)result);
        return globalResult;
    }

    public JSONObject getAllProperties(String processInstanceId) {
        String processDefinitionId = null;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (historicProcessInstance != null) {
                processDefinitionId = historicProcessInstance.getProcessDefinitionId();
            }
        } else {
            processDefinitionId = processInstance.getProcessDefinitionId();
        }
        if (processDefinitionId == null) {
            return new JSONObject();
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        JSONObject globalResult = new JSONObject();
        Collection processCollection = bpmnModelInstance.getModelElementsByType(Process.class);
        if (processCollection != null) {
            for (Process process : processCollection) {
                Collection properties;
                ExtensionElements extensionElements = process.getExtensionElements();
                if (extensionElements == null || !CollUtil.isNotEmpty((Collection)extensionElements.getElements()) || !CollUtil.isNotEmpty((Collection)(properties = ((CamundaProperties)extensionElements.getElementsQuery().filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) continue;
                for (CamundaProperty property : properties) {
                    String name = property.getCamundaName();
                    String value = property.getCamundaValue();
                    globalResult.put(name, (Object)value);
                }
            }
        }
        Collection modelElementsByType = bpmnModelInstance.getModelElementsByType(UserTask.class);
        for (UserTask userTask : modelElementsByType) {
            Collection camundaProperties;
            Query elementsQuery;
            ExtensionElements extensionElements = userTask.getExtensionElements();
            if (extensionElements == null || (elementsQuery = extensionElements.getElementsQuery()) == null || !CollUtil.isNotEmpty((Collection)(camundaProperties = ((CamundaProperties)elementsQuery.filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) continue;
            JSONObject result = new JSONObject();
            for (CamundaProperty camundaProperty : camundaProperties) {
                result.put(camundaProperty.getCamundaName(), (Object)camundaProperty.getCamundaValue());
            }
            globalResult.put(userTask.getId(), (Object)result);
        }
        return globalResult;
    }
}

