CREATE TABLE `lowcode_logic_behavior` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `project_id` bigint(20) NOT NULL COMMENT '项目id',
  `module_id` bigint(20) DEFAULT NULL COMMENT '接口id',
  `logic_id` bigint(20) NOT NULL COMMENT '逻辑模型id',
  `behavior_name` varchar(32) NOT NULL COMMENT '名称',
  `behavior_code` varchar(64) NOT NULL COMMENT '编码',
  `behavior_pingyin` varchar(255) NOT NULL COMMENT '名称拼音',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `create_user` bigint(20) DEFAULT NULL COMMENT '创建人',
  `gmt_create` datetime DEFAULT NULL COMMENT '创建时间',
  `modified_user` bigint(20) DEFAULT NULL COMMENT '修改用户',
  `gmt_modified` datetime DEFAULT NULL COMMENT '修改时间',
  `valid` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态:-1 删除, 0 正常',
  `valid_id` bigint DEFAULT NULL COMMENT '删除标识id，默认等于id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_logicId_behaviorCode_valid` (`logic_id`,`behavior_code`,`valid`,`valid_id`),
  KEY `idx_projectId_behaviorCode` (`project_id`,`behavior_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='数据模型-逻辑模型行为表';