var manateeJsFun = Java.type("com.manatee.lowcode.process.js.JsFun");

function isBlank(value) {
    if (typeof (value) == undefined ||
        value == undefined ||
        value == null) {
        return true;
    }
    if(typeof (value.trim) === 'function') {
        return value.trim() == "";
    }
    throw new Error("入参不是String类型");
}

function isNotBlank(value) {
    return !isBlank(value);
}

function isNull(value) {
    return typeof (value) == undefined || value == undefined || value == null;
}

function isNotNull(value) {
    return !isNull(value);
}

function isEmpty(value) {
    if (typeof (value) == undefined
        || value == undefined //未初始化的判断
        || value == null //object类型的判断
        || (typeof (value) == 'object' && value.size() <= 0)
        || (typeof (value) == 'string' && isBlank(value))
        || (typeof (value) == 'number' && isNaN(value))) {
        return true;
    }
    return false;
}

function isNotEmpty(value) {
    return !isEmpty(value);
}

function addToList(list,value) {
    list.add(value);
    return list;
}
