/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.socket.ws;

import com.manatee.common.exception.BizException;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.socket.base.BaseWebsocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebsocketClientProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(WebsocketClientProcess.class);
    @Autowired
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"wsUri"});
        this.processConfUtil.checkConf(content, new String[]{"sendMsg"});
        this.processConfUtil.checkConf(content, new String[]{"clientName"});
        String wsUri = this.variableUtil.calVarInConf(content, "wsUri");
        String sendMsg = this.variableUtil.calVarInConf(content, "sendMsg");
        String clientName = this.variableUtil.calVarInConf(content, "clientName");
        BaseWebsocketClient websocketClient = null;
        try {
            URI uri = new URI(wsUri);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            websocketClient = new BaseWebsocketClient(uri, httpHeaders, clientName, sendMsg);
            websocketClient.connect();
        }
        catch (URISyntaxException e) {
            LOGGER.error("process error, wsUri: \u3010{}\u3011, sendMsg:\u3010{}\u3011, clientName:\u3010{}\u3011, e:\u3010{}\u3011", new Object[]{wsUri, sendMsg, clientName, e});
            throw new BizException((Throwable)e);
        }
        finally {
            if (websocketClient != null) {
                websocketClient.close();
            }
        }
    }

    public String getName() {
        return "websocketClient";
    }
}

