/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeUpdateProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeUpdateProcess.class);
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    protected IInputUtil inputUtil;
    @Resource
    private TenantManager tenantManager;

    /*
     * WARNING - void declaration
     */
    public void process(ProcessContent content) throws BizException {
        int updateCount;
        block18: {
            this.processConfUtil.checkConf(content, new String[]{"table"});
            String db = this.variableUtil.calVarInConf(content, "db");
            DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
            String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
            if (StringUtil.isBlank((String)dataBaseName)) {
                dataBaseName = dataSource.getDataBaseName();
            }
            String handleType = content.getStepConfString("handleType");
            updateCount = 0;
            ThreadLocalConnection.INSTANCE.setProcessContent(content);
            try {
                if ("batch".equals(handleType)) {
                    List recordAndWhereList = (List)this.createRecordAndWhereList(content, dataBaseName);
                    String paramsIsNull = content.getStepConfString("paramsIsNull");
                    if ((StrUtil.isBlank((CharSequence)paramsIsNull) || StrUtil.equals((CharSequence)paramsIsNull, (CharSequence)"error")) && CollUtil.isEmpty((Collection)recordAndWhereList)) {
                        throw new BizException(ResultCode.CONF_ERROR, String.format("\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570:\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a", content.getStepConf("paramsKey")));
                    }
                    if (StrUtil.equals((CharSequence)paramsIsNull, (CharSequence)"skip") && CollUtil.isEmpty((Collection)recordAndWhereList)) {
                        return;
                    }
                    Integer updateBatchNumber = null;
                    try {
                        String updateBatchNumberStr = content.getStepConf().getString("updateBatchNumber");
                        if (StringUtils.isNotEmpty((CharSequence)updateBatchNumberStr)) {
                            updateBatchNumberStr = this.variableUtil.calVar(content, updateBatchNumberStr);
                            updateBatchNumber = Integer.parseInt(updateBatchNumberStr);
                        }
                    }
                    catch (Exception e) {
                        throw new BizException(ResultCode.SYSTEM_ERROR, "\u5355\u6b21\u66f4\u65b0\u6570\u91cf\u9700\u4e3a\u6570\u5b57");
                    }
                    ArrayList<List> recordsList = new ArrayList<List>();
                    if (updateBatchNumber != null && updateBatchNumber > 0) {
                        void var13_19;
                        int numOfChunks = (int)Math.ceil((double)recordAndWhereList.size() / (double)updateBatchNumber.intValue());
                        boolean bl = false;
                        while (var13_19 < numOfChunks) {
                            void fromIndex = var13_19 * updateBatchNumber;
                            int toIndex = Math.min((int)(fromIndex + updateBatchNumber), recordAndWhereList.size());
                            recordsList.add(recordAndWhereList.subList((int)fromIndex, toIndex));
                            ++var13_19;
                        }
                    } else {
                        recordsList.add(recordAndWhereList);
                    }
                    for (Collection collection : recordsList) {
                        int update = DbClient.use(db).updateBatch(collection);
                        updateCount += collection.size();
                    }
                    break block18;
                }
                DbEntity where = this.createWhere(content, dataBaseName);
                this.tenantManager.addTenantToEntity(content, where);
                DbEntity record = this.createRecord(content, dataBaseName);
                updateCount = DbClient.use(db).update(record, where);
            }
            catch (SQLException e) {
                if (StringUtil.isBlank((String)db)) {
                    db = "default";
                }
                this.LOGGER.error("manateeUpdateProcess error , db:\u3010{}\u3011", (Object)db);
                throw new BizException((Throwable)e);
            }
            finally {
                ThreadLocalConnection.INSTANCE.removeProcessContent();
            }
        }
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)updateCount);
    }

    public String getName() {
        return "manateeUpdateProcess";
    }

    private DbEntity createRecord(ProcessContent content, String dataBaseName) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        List<Map> updateListParams = this.dBManager.getUpdateListParams(content);
        if (CollUtil.isEmpty(updateListParams)) {
            String syntaxType = content.getStepConf().getString("syntaxTypeUpdateParams");
            Map<String, Object> updateParams = this.dBManager.getUpdateParamsV2(content, syntaxType);
            if (CollUtil.isEmpty(updateParams)) {
                return null;
            }
            if (updateListParams == null) {
                updateListParams = new ArrayList<Map>();
            }
            for (Map.Entry<String, Object> param : updateParams.entrySet()) {
                JSONObject paramJson = new JSONObject();
                paramJson.put("fieldName", (Object)param.getKey());
                paramJson.put("fieldValue", param.getValue());
                updateListParams.add((Map)paramJson);
            }
        }
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table);
        return dbEntity.setInsertConditionList(updateListParams);
    }

    private DbEntity createWhere(ProcessContent content, String dataBaseName) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        String syntaxType = content.getStepConf().getString("syntaxType");
        List<Map> queryListParams = this.dBManager.getQueryListParamsV2(content, syntaxType);
        JSONArray in = this.dBManager.in(content);
        DBUpdate delete = new DBUpdate();
        this.dBManager.in(in, delete);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, delete.getIn());
        return dbEntity;
    }

    private Collection<Map> createRecordAndWhereList(ProcessContent content, String dataBaseName) throws BizException {
        String syntaxType = content.getStepConf().getString("syntaxType");
        List handleListObject = (List)this.inputUtil.getHandleListObjectV2(content, content.getStepConf("queryParamsArray"), "fieldValue", "paramsKey", syntaxType);
        if (CollUtil.isEmpty((Collection)handleListObject)) {
            return null;
        }
        List whereList = (List)this.createWhereList(content, dataBaseName, handleListObject);
        List recordList = (List)this.createRecordList(content, dataBaseName);
        if (whereList == null || recordList == null) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u8bf7\u68c0\u67e5\u6279\u91cf\u66f4\u65b0\u6570\u636e");
        }
        ArrayList<Map> recordAndWhereList = new ArrayList<Map>(whereList.size());
        for (int i = 0; i < whereList.size(); ++i) {
            HashMap map = new HashMap(2);
            map.put("record", recordList.get(i));
            map.put("where", whereList.get(i));
            recordAndWhereList.add(map);
        }
        return recordAndWhereList;
    }

    private Collection<DbEntity> createWhereList(ProcessContent content, String dataBaseName, List<List<Map>> handleListObject) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        JSONArray in = this.dBManager.in(content);
        DBUpdate update = new DBUpdate();
        this.dBManager.in(in, update);
        ArrayList<DbEntity> result = new ArrayList<DbEntity>(handleListObject.size());
        for (List<Map> queryListParams : handleListObject) {
            DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, update.getIn());
            result.add(dbEntity);
        }
        return result;
    }

    private Collection<DbEntity> createRecordList(ProcessContent content, String dataBaseName) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        String syntaxType = content.getStepConf().getString("syntaxTypeUpdateParams");
        List updateParamsObject = (List)this.inputUtil.getHandleDataV2(content, "updateParams", syntaxType);
        if (CollUtil.isEmpty((Collection)updateParamsObject)) {
            return null;
        }
        ArrayList<DbEntity> result = new ArrayList<DbEntity>(updateParamsObject.size());
        for (Map map : updateParamsObject) {
            ArrayList<Map> mapList = new ArrayList<Map>(2);
            for (Map.Entry param : map.entrySet()) {
                JSONObject paramJson = new JSONObject();
                paramJson.put("fieldName", param.getKey());
                paramJson.put("fieldValue", param.getValue());
                mapList.add((Map)paramJson);
            }
            DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setInsertConditionList(mapList);
            result.add(dbEntity);
        }
        return result;
    }
}

