/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.process;

import com.alibaba.fastjson.JSONArray;
import com.manatee.common.domain.DBUpdate;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.OutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcodedb.manager.DBManager;
import com.manatee.lowcodedb.newdb.DbClient;
import com.manatee.lowcodedb.newdb.DbEntity;
import com.manatee.lowcodedb.newdb.ThreadLocalConnection;
import com.manatee.lowcodedb.newdb.ds.DSFactory;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import com.manatee.lowcodedb.newdb.tenant.manager.TenantManager;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManateeDeleteProcess
implements IProcess {
    private Logger LOGGER = LoggerFactory.getLogger(ManateeDeleteProcess.class);
    @Resource
    protected OutputUtil outputUtil;
    @Resource
    private DBManager dBManager;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private TenantManager tenantManager;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"table"});
        String db = this.variableUtil.calVarInConf(content, "db");
        DataSourceWrapper dataSource = (DataSourceWrapper)DSFactory.get(db);
        String dataBaseName = this.variableUtil.calVarInConf(content, "schema");
        if (StringUtil.isBlank((String)dataBaseName)) {
            dataBaseName = dataSource.getDataBaseName();
        }
        DbEntity dbEntity = this.createDbEntity(content, dataBaseName);
        int deleteCount = 0;
        ThreadLocalConnection.INSTANCE.setProcessContent(content);
        try {
            deleteCount = DbClient.use(db).del(dbEntity);
        }
        catch (SQLException e) {
            this.LOGGER.error("ManateeDeleteProcess error , db:\u3010{}\u3011", (Object)db);
            throw new BizException((Throwable)e);
        }
        finally {
            ThreadLocalConnection.INSTANCE.removeProcessContent();
        }
        this.outputUtil.setDefaultReturnKey(content, "count");
        this.outputUtil.putData(content, (Object)deleteCount);
    }

    public String getName() {
        return "manateeDeleteProcess";
    }

    private DbEntity createDbEntity(ProcessContent content, String dataBaseName) throws BizException {
        String table = this.variableUtil.calVarInConf(content, "table");
        String syntaxType = content.getStepConf().getString("syntaxType");
        List<Map> queryListParams = this.dBManager.getQueryListParamsV2(content, syntaxType);
        JSONArray in = this.dBManager.in(content);
        DBUpdate delete = new DBUpdate();
        this.dBManager.in(in, delete);
        DbEntity dbEntity = DbEntity.create(dataBaseName + '.' + table).setWhereConditionListForDbQuery(table, queryListParams, content).setInConditionForDbQuery(table, delete.getIn());
        this.tenantManager.addTenantToEntity(content, dbEntity);
        return dbEntity;
    }
}

