/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.config;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcodedb.newdb.ds.DataSourceWrapper;
import io.seata.rm.datasource.DataSourceProxy;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="ManateeDataSource")
@Order
public class ManateeDataSource
implements InitializingBean,
ApplicationContextAware {
    private static Logger LOGGER = LoggerFactory.getLogger(ManateeDataSource.class);
    public static Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    protected static Map<String, DataSourceWrapper> DATA_SOURCE_WRAPPER_MAP = new HashMap<String, DataSourceWrapper>();
    @Value(value="${seata.tx-service-group:}")
    private String txServiceGroup;
    @Autowired
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.applicationContext.getBean("dataSource", DataSource.class);
        }
        catch (BeansException e) {
            Map othderDsMap = this.applicationContext.getBeansOfType(DataSource.class);
            if (othderDsMap.size() > 1) {
                for (Map.Entry dataSourceEntry : othderDsMap.entrySet()) {
                    if (((String)dataSourceEntry.getKey()).toLowerCase().indexOf("master") == -1) continue;
                    dataSource = (DataSource)othderDsMap.get(othderDsMap.keySet().iterator().next());
                }
            }
            dataSource = (DataSource)othderDsMap.get(othderDsMap.keySet().iterator().next());
        }
        if (dataSource != null) {
            if (StringUtil.isNotBlank((String)this.txServiceGroup)) {
                ManateeDataSource.addDataSource("default", (DataSource)new DataSourceProxy(dataSource));
            } else {
                ManateeDataSource.addDataSource("default", dataSource);
            }
        }
    }

    public Connection getConnection(String name) throws SQLException, BizException {
        DataSource dataSource;
        if (StringUtil.isBlank((String)name)) {
            name = "default";
        }
        if ("hainiu_lowcode".equals(name) && !dataSourceMap.containsKey("hainiu_lowcode")) {
            name = "default";
        }
        if ((dataSource = dataSourceMap.get(name)) == null) {
            throw new BizException(ResultCode.CONF_ERROR, "dataSource_is_null,dataSource:" + name);
        }
        return dataSource.getConnection();
    }

    public static DataSourceWrapper getDs(String name) throws BizException {
        DataSourceWrapper dataSource;
        if (StringUtil.isBlank((String)name)) {
            name = "default";
        }
        if ("hainiu_lowcode".equals(name) && !DATA_SOURCE_WRAPPER_MAP.containsKey("hainiu_lowcode")) {
            name = "default";
        }
        if ((dataSource = DATA_SOURCE_WRAPPER_MAP.get(name)) == null) {
            throw new BizException(ResultCode.CONF_ERROR, "dataSource_is_null,dataSource:" + name);
        }
        return dataSource;
    }

    public static void removeDs(String name) throws BizException {
        if (StringUtil.isBlank((String)name) || "hainiu_lowcode".equals(name) && !dataSourceMap.containsKey("hainiu_lowcode")) {
            throw new BizException(ResultCode.CONF_ERROR, "can not remove DataSource: " + name);
        }
        DataSource dataSource = dataSourceMap.remove(name);
    }

    @PreDestroy
    private void destroy() {
        for (String name : dataSourceMap.keySet()) {
            Closeable closeable = (Closeable)((Object)dataSourceMap.get(name));
            if (closeable == null) continue;
            try {
                closeable.close();
                System.out.println("datasource " + name + " destroy......................");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addDataSource(String key, DataSource value) {
        dataSourceMap.put(key, value);
        DataSourceWrapper dataSourceWrapper = new DataSourceWrapper(value);
        DATA_SOURCE_WRAPPER_MAP.put(key, dataSourceWrapper);
    }

    public static Set<String> getDataSourceNameSet() {
        HashSet<String> dataSourceNameSet = new HashSet<String>();
        for (String keyName : dataSourceMap.keySet()) {
            if (keyName.indexOf(":") != -1) continue;
            dataSourceNameSet.add(keyName);
        }
        return dataSourceNameSet;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, DataSource> getAllDataSource() {
        return dataSourceMap;
    }
}

