/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.base;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.date.DateUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MybatisXml2SqlParser {
    private static final String sqlXmlPrefix = "<sql>";
    private static final String sqlXmlSuffix = "</sql>";

    public static String getSql(String content, Map<String, Object> param) throws Exception {
        content = sqlXmlPrefix + content + sqlXmlSuffix;
        Configuration configuration = new Configuration();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builders = factory.newDocumentBuilder();
        Document doc = builders.parse(new InputSource(new StringReader(content)));
        XPathParser xPathParser = new XPathParser(doc, false);
        Node node = doc.getFirstChild();
        XNode xNode = new XNode(xPathParser, node, null);
        XMLScriptBuilder xmlScriptBuilder = new XMLScriptBuilder(configuration, xNode);
        SqlSource sqlSource = xmlScriptBuilder.parseScriptNode();
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, content, sqlSource, null);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ArrayList resultMappings = new ArrayList();
        ResultMap.Builder resultMapBuilder = new ResultMap.Builder(configuration, content, Map.class, resultMappings, Boolean.valueOf(true));
        resultMaps.add(resultMapBuilder.build());
        MappedStatement ms = builder.resultMaps(resultMaps).build();
        BoundSql boundSql = ms.getBoundSql(param);
        String sql = boundSql.getSql();
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (parameterMappings != null) {
            MetaObject newMetaObject = configuration.newMetaObject(parameterObject);
            sql = sql.replaceAll("\\?", "###WH###");
            for (ParameterMapping parameterMapping : parameterMappings) {
                String parameter = "null";
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    parameter = MybatisXml2SqlParser.getParameterValue(parameterObject);
                } else if (newMetaObject.hasGetter(propertyName)) {
                    parameter = MybatisXml2SqlParser.getParameterValue(newMetaObject.getValue(propertyName));
                } else if (boundSql.hasAdditionalParameter(propertyName)) {
                    parameter = MybatisXml2SqlParser.getParameterValue(boundSql.getAdditionalParameter(propertyName));
                }
                sql = sql.replaceFirst("###WH###", Matcher.quoteReplacement(parameter));
            }
            return sql.replaceAll("[\r\n\t]", " ").replaceAll(" + ", " ");
        }
        return null;
    }

    public static String getSqlV2(String content, Map<String, Object> param, List<Object> paramValues, Map<Integer, JSONObject> outParams) throws Exception {
        content = sqlXmlPrefix + content + sqlXmlSuffix;
        Configuration configuration = new Configuration();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builders = factory.newDocumentBuilder();
        Document doc = builders.parse(new InputSource(new StringReader(content)));
        XPathParser xPathParser = new XPathParser(doc, false);
        Node node = doc.getFirstChild();
        XNode xNode = new XNode(xPathParser, node, null);
        XMLScriptBuilder xmlScriptBuilder = new XMLScriptBuilder(configuration, xNode);
        SqlSource sqlSource = xmlScriptBuilder.parseScriptNode();
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, content, sqlSource, null);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ArrayList resultMappings = new ArrayList();
        ResultMap.Builder resultMapBuilder = new ResultMap.Builder(configuration, content, Map.class, resultMappings, Boolean.valueOf(true));
        resultMaps.add(resultMapBuilder.build());
        MappedStatement ms = builder.resultMaps(resultMaps).build();
        BoundSql boundSql = ms.getBoundSql(param);
        String sql = boundSql.getSql();
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (parameterMappings != null) {
            MetaObject newMetaObject = configuration.newMetaObject(parameterObject);
            int index = 0;
            for (ParameterMapping parameterMapping : parameterMappings) {
                ++index;
                Object parameter = "null";
                String propertyName = parameterMapping.getProperty();
                if (parameterMapping.getMode() == ParameterMode.OUT) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("keyName", (Object)propertyName);
                    jsonObject.put("jdbcType", (Object)parameterMapping.getJdbcType());
                    outParams.put(index, jsonObject);
                    paramValues.add(parameterMapping.getJdbcType().TYPE_CODE);
                    continue;
                }
                if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    parameter = parameterObject;
                } else if (newMetaObject.hasGetter(propertyName)) {
                    parameter = newMetaObject.getValue(propertyName);
                } else if (boundSql.hasAdditionalParameter(propertyName)) {
                    parameter = boundSql.getAdditionalParameter(propertyName);
                }
                paramValues.add(parameter);
            }
            return sql.replaceAll("[\r\n\t]", " ").replaceAll(" + ", " ");
        }
        return null;
    }

    private static String getParameterValue(Object param) throws BizException {
        String value;
        if (param == null) {
            return "null";
        }
        if (param instanceof Number) {
            return param.toString();
        }
        if (param instanceof String) {
            MybatisXml2SqlParser.sqlInject(param.toString());
            value = "'" + param.toString() + "'";
        } else if (param instanceof Date) {
            value = "'" + DateUtil.formatDateTime((Date)((Date)param)) + "'";
        } else if (param instanceof Enum) {
            value = "'" + ((Enum)param).name() + "'";
        } else {
            MybatisXml2SqlParser.sqlInject(param.toString());
            value = param.toString();
        }
        return value;
    }

    public static String sqlInject(String str) throws BizException {
        String[] keywords;
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        str = StringUtils.replace((String)str, (String)"'", (String)"''");
        str = StringUtils.replace((String)str, (String)"\"", (String)"'\"");
        str = StringUtils.replace((String)str, (String)";", (String)"';");
        str = StringUtils.replace((String)str, (String)"\\", (String)"'\\");
        str = StringUtils.replace((String)str, (String)"%", (String)"\\%");
        str = StringUtils.replace((String)str, (String)"_", (String)"\\_");
        String str1 = str.toLowerCase();
        for (String keyword : keywords = new String[]{"master ", "truncate ", "insert ", "select ", "delete ", "update ", "declare ", "alert ", "drop "}) {
            if (str1.indexOf(keyword) == -1) continue;
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        return str;
    }
}

