/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.StringUtil;
import com.manatee.process.domain.ProcessContent;

public class ProjectConfUtil {
    private static String DEFAULT_VERSION = "1.0";

    public static boolean isFromInsidePackage(ProcessContent content) {
        JSONObject conf = (JSONObject)ProjectConfUtil.getGlobalConf(content, "fromInsidePackage");
        if (conf == null) {
            return false;
        }
        return ProjectConfUtil.globalResult(content, "fromInsidePackage");
    }

    public static boolean isCamelCaseWhenUnderline(ProcessContent content) {
        JSONObject conf = (JSONObject)ProjectConfUtil.getGlobalConf(content, "camelCaseWhenUnderline");
        if (conf == null) {
            return true;
        }
        return ProjectConfUtil.globalResult(content, "camelCaseWhenUnderline");
    }

    public static boolean globalResult(ProcessContent content, JSONObject conf) {
        return ProjectConfUtil.getGlobalResult(content, conf);
    }

    public static boolean globalResult(ProcessContent content, String key) {
        boolean result = true;
        JSONObject conf = (JSONObject)ProjectConfUtil.getGlobalConf(content, key);
        if (conf == null) {
            return result;
        }
        return ProjectConfUtil.getGlobalResult(content, conf);
    }

    public static boolean globalResult(ProcessContent content, String key, boolean defaultResult) {
        JSONObject conf = (JSONObject)ProjectConfUtil.getGlobalConf(content, key);
        if (conf == null) {
            return defaultResult;
        }
        return ProjectConfUtil.getGlobalResult(content, conf);
    }

    public static Object getGlobalConf(ProcessContent content, String key) {
        JSONObject conf = content.getProjectConf();
        if (conf == null) {
            return null;
        }
        JSONObject globalConf = conf.getJSONObject("conf");
        if (globalConf == null) {
            return null;
        }
        return globalConf.getJSONObject(key);
    }

    public static Object getArrayGlobalConf(ProcessContent content, String key) {
        JSONObject conf = content.getProjectConf();
        if (conf == null) {
            return null;
        }
        JSONObject globalConf = conf.getJSONObject("conf");
        if (globalConf == null) {
            return null;
        }
        return globalConf.getJSONArray(key);
    }

    private static boolean getGlobalResult(ProcessContent content, JSONObject conf) {
        String confVersion;
        boolean result = true;
        String version = (String)content.getModule("systemVersion");
        if (ProjectConfUtil.isBeforeVersion(version, confVersion = conf.getString("version"))) {
            Boolean re = conf.getBoolean("beforeVersion");
            if (re != null) {
                result = re;
            }
        } else {
            Boolean re = conf.getBoolean("equalAndAfterVersion");
            if (re != null) {
                result = re;
            }
        }
        return result;
    }

    private static boolean isBeforeVersion(String version, String confVersion) {
        if (StringUtil.isBlank(version)) {
            version = DEFAULT_VERSION;
        }
        if (StringUtil.isBlank(confVersion)) {
            confVersion = DEFAULT_VERSION;
        }
        String[] versionArray = version.split("\\.");
        String[] confVersionArray = confVersion.split("\\.");
        long versionNum = 0L;
        if (versionArray.length >= 1) {
            versionNum += Long.parseLong(versionArray[0]) * 100000000L;
        }
        if (versionArray.length >= 2) {
            versionNum += Long.parseLong(versionArray[1]) * 1000000L;
        }
        if (versionArray.length >= 3) {
            versionNum += Long.parseLong(versionArray[2]) * 10000L;
        }
        if (versionArray.length >= 4) {
            versionNum += Long.parseLong(versionArray[3]) * 100L;
        }
        long versionConfNum = 0L;
        if (confVersionArray.length >= 1) {
            versionConfNum += Long.parseLong(confVersionArray[0]) * 100000000L;
        }
        if (confVersionArray.length >= 2) {
            versionConfNum += Long.parseLong(confVersionArray[1]) * 1000000L;
        }
        if (confVersionArray.length >= 3) {
            versionConfNum += Long.parseLong(confVersionArray[2]) * 10000L;
        }
        if (confVersionArray.length >= 4) {
            versionConfNum += Long.parseLong(confVersionArray[3]) * 100L;
        }
        return versionNum < versionConfNum;
    }
}

