/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.domain;

import com.manatee.annotations.ManateeParams;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.lang.reflect.Parameter;

public class ManateeParamsDTO {
    private String paramsName;
    private Object defaultValue;
    private boolean required = false;
    private boolean allowMultiple = false;
    private String dataType;
    private Class<?> dataTypeClass = Void.class;

    public static ManateeParamsDTO build(ManateeParams annotation, Parameter parameter) {
        ManateeParamsDTO param = new ManateeParamsDTO();
        if (annotation.required()) {
            param.setRequired(annotation.required());
        }
        if (annotation.allowMultiple()) {
            param.setAllowMultiple(annotation.allowMultiple());
        }
        param.setParamsName(annotation.value());
        if (StrUtil.isNotBlank(annotation.dataType())) {
            param.setDataType(annotation.dataType());
        } else {
            param.setDataType(parameter.getType().getName());
        }
        if (annotation.dataTypeClass() == Void.class) {
            param.setDataTypeClass(parameter.getType());
        } else {
            param.setDataTypeClass(annotation.dataTypeClass());
        }
        return param;
    }

    public String getParamsName() {
        return this.paramsName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Class<?> getDataTypeClass() {
        return this.dataTypeClass;
    }

    public void setParamsName(String paramsName) {
        this.paramsName = paramsName;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDataTypeClass(Class<?> dataTypeClass) {
        this.dataTypeClass = dataTypeClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManateeParamsDTO)) {
            return false;
        }
        ManateeParamsDTO other = (ManateeParamsDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paramsName = this.getParamsName();
        String other$paramsName = other.getParamsName();
        if (this$paramsName == null ? other$paramsName != null : !this$paramsName.equals(other$paramsName)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isAllowMultiple() != other.isAllowMultiple()) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Class<?> this$dataTypeClass = this.getDataTypeClass();
        Class<?> other$dataTypeClass = other.getDataTypeClass();
        return !(this$dataTypeClass == null ? other$dataTypeClass != null : !this$dataTypeClass.equals(other$dataTypeClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManateeParamsDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paramsName = this.getParamsName();
        result = result * 59 + ($paramsName == null ? 43 : $paramsName.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isAllowMultiple() ? 79 : 97);
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Class<?> $dataTypeClass = this.getDataTypeClass();
        result = result * 59 + ($dataTypeClass == null ? 43 : $dataTypeClass.hashCode());
        return result;
    }

    public String toString() {
        return "ManateeParamsDTO(paramsName=" + this.getParamsName() + ", defaultValue=" + this.getDefaultValue() + ", required=" + this.isRequired() + ", allowMultiple=" + this.isAllowMultiple() + ", dataType=" + this.getDataType() + ", dataTypeClass=" + this.getDataTypeClass() + ")";
    }
}

