/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.json;

import com.manatee.common.util.tool.core.convert.Convert;
import com.manatee.common.util.tool.core.convert.ConvertException;
import com.manatee.common.util.tool.core.convert.Converter;
import com.manatee.common.util.tool.core.convert.ConverterRegistry;
import com.manatee.common.util.tool.core.convert.impl.ArrayConverter;
import com.manatee.common.util.tool.core.util.ObjectUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.core.util.TypeUtil;
import com.manatee.common.util.tool.json.JSON;
import com.manatee.common.util.tool.json.JSONArray;
import com.manatee.common.util.tool.json.JSONObject;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.common.util.tool.json.serialize.GlobalSerializeMapping;
import com.manatee.common.util.tool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert(jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        JSONDeserializer<?> deserializer;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON && null != (deserializer = GlobalSerializeMapping.getDeserializer(targetType))) {
            return (T)deserializer.deserialize((JSON)value);
        }
        T targetValue = Convert.convertWithCheck(targetType, value, null, ignoreError);
        if (null == targetValue && !ignoreError) {
            if (StrUtil.isBlankIfStr(value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", value, ObjectUtil.defaultIfNull(TypeUtil.getClass(targetType), targetType));
        }
        return targetValue;
    }

    @Override
    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom((Type)((Object)JSON.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONObject.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONArray.class), (Class<? extends Converter<?>>)JSONConverter.class);
    }
}

