/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.crypto.symmetric;

import com.manatee.common.util.tool.core.codec.Base64;
import com.manatee.common.util.tool.core.io.IORuntimeException;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.lang.Assert;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.HexUtil;
import com.manatee.common.util.tool.core.util.RandomUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.crypto.CryptoException;
import com.manatee.common.util.tool.crypto.KeyUtil;
import com.manatee.common.util.tool.crypto.Padding;
import com.manatee.common.util.tool.crypto.SecureUtil;
import com.manatee.common.util.tool.crypto.symmetric.SymmetricAlgorithm;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        if (null != paramsSpec) {
            this.setParams(paramsSpec);
        }
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        Assert.notBlank(algorithm, "'algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomUtil.randomBytes(8), 100);
        }
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StrUtil.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = SecureUtil.createCipher(algorithm);
        return this;
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SymmetricCrypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(1, this.secretKey);
            } else {
                this.cipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(this.paddingDataWithZero(data, this.cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encryptHex(byte[] data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(byte[] data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset));
    }

    public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset));
    }

    public String encryptHex(String data, String charset) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, String charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public String encryptBase64(String data, Charset charset) {
        return Base64.encode(this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, CharsetUtil.CHARSET_UTF_8));
    }

    public String encryptHex(String data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(String data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data));
    }

    public String encryptHex(InputStream data) {
        return HexUtil.encodeHexStr(this.encrypt(data));
    }

    public String encryptBase64(InputStream data) {
        return Base64.encode(this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            blockSize = this.cipher.getBlockSize();
            decryptData = this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    public String decryptStr(byte[] bytes, Charset charset) {
        return StrUtil.str(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode(data));
    }

    public String decryptStr(String data, Charset charset) {
        return StrUtil.str(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decrypt(InputStream data) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data));
    }

    public String decryptStr(InputStream data, Charset charset) {
        return StrUtil.str(this.decrypt(data), charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayUtil.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayUtil.resize(data, i + 1);
        }
        return data;
    }
}

