/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.crypto.symmetric;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.crypto.Mode;
import com.manatee.common.util.tool.crypto.Padding;
import com.manatee.common.util.tool.crypto.SecureUtil;
import com.manatee.common.util.tool.crypto.symmetric.SymmetricAlgorithm;
import com.manatee.common.util.tool.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(SymmetricAlgorithm.DES);
    }

    public DES(byte[] key) {
        super(SymmetricAlgorithm.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, SecureUtil.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format("DES/{}/{}", mode, padding), key, iv);
    }
}

