/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.date;

public enum Week {
    SUNDAY(1),
    MONDAY(2),
    TUESDAY(3),
    WEDNESDAY(4),
    THURSDAY(5),
    FRIDAY(6),
    SATURDAY(7);

    private final int value;

    private Week(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toChinese() {
        return this.toChinese("\u661f\u671f");
    }

    public String toChinese(String weekNamePre) {
        switch (this) {
            case SUNDAY: {
                return weekNamePre + "\u65e5";
            }
            case MONDAY: {
                return weekNamePre + "\u4e00";
            }
            case TUESDAY: {
                return weekNamePre + "\u4e8c";
            }
            case WEDNESDAY: {
                return weekNamePre + "\u4e09";
            }
            case THURSDAY: {
                return weekNamePre + "\u56db";
            }
            case FRIDAY: {
                return weekNamePre + "\u4e94";
            }
            case SATURDAY: {
                return weekNamePre + "\u516d";
            }
        }
        return null;
    }

    public static Week of(int calendarWeekIntValue) {
        switch (calendarWeekIntValue) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        return null;
    }
}

