/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.DateUtils;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TimeUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_1 = "yyyy.MM.dd";
    public static final String DATE_FORMAT_2 = "yyyyMMdd";
    public static final String DATE_FORMAT_3 = "HH:mm";
    public static final String DATE_FORMAT_4 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_5 = "yyyy/MM/dd";
    public static final String DATE_FORMAT_6 = "yyyyMM";
    public static final String DATE_FORMAT_7 = "MM/dd";
    public static final String DATE_FORMAT_8 = "yyyy/M/d";
    public static final String DATE_FORMAT_LONG = "millisecond";
    public static final String DATE_FORMAT_LONG_1 = "second";
    public static String[] timeStrPatterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy/MM/dd'T'HH:mm:ss.SSS'Z'", "yyyy/MM/dd HH:mm:ss.SSS'Z'", "yyyy/MM/dd'T'HH:mm:ss.SSS", "yyyy/MM/dd'T'HH:mm:ss'Z'", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss'Z'", "yyyy/MM/dd'T'HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd", "yyyy/MM"};
    private static ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_1 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_1);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_2 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_2);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_3 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_3);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_4 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_4);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_5 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_5);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_6 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_6);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_7 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_7);
        }
    };
    private static ThreadLocal<SimpleDateFormat> threadLocal_8 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeUtil.DATE_FORMAT_8);
        }
    };
    private static Map<String, ThreadLocal<SimpleDateFormat>> localMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    public static final long TIME_LONG = 1000000000L;

    public static Date format2Date(Object timeObj, String format) throws ParseException {
        if (timeObj == null) {
            return null;
        }
        if (TimeUtil.isTimeLong(timeObj, format)) {
            return TimeUtil.long2Time(timeObj, format);
        }
        if (StringUtil.isBlank(format) || format.indexOf("T") != -1) {
            format = DATE_FORMAT;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        if (timeObj.toString().contains("T")) {
            String newTimeStr = timeObj.toString().replace("T", " ");
            if (timeObj.toString().length() > 19) {
                newTimeStr = newTimeStr.substring(0, 19);
            }
            return formatter.parse(newTimeStr);
        }
        return formatter.parse(timeObj + "");
    }

    public static Date getFunctionDate(Object dateObj, String fromFormat) {
        Date resultDate;
        if (dateObj instanceof Date) {
            resultDate = (Date)dateObj;
        } else if (dateObj instanceof Double) {
            dateObj = ((Double)dateObj).longValue();
            resultDate = new Date(Long.parseLong(dateObj.toString()));
        } else {
            resultDate = Pattern.compile("[0-9]*").matcher(dateObj.toString()).matches() ? new Date(Long.parseLong(dateObj.toString())) : TimeUtil.getDateByFormat(dateObj, fromFormat);
        }
        return resultDate;
    }

    public static Date parseStringToDate(String dateStr) {
        try {
            Date date = org.apache.commons.lang3.time.DateUtils.parseDate((String)dateStr, (String[])timeStrPatterns);
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65f6\u95f4\u5b57\u7b26\u4e32\u8f6c\u6362\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u683c\u5f0f");
        }
    }

    public static Date getDateByFormat(Object dateObj, String format) {
        return TimeUtil.getDateByFormat(dateObj, format, false);
    }

    public static Date getDateByFormat(Object dateObj, String format, boolean lenient) {
        if (dateObj instanceof Date) {
            return (Date)dateObj;
        }
        String dateStr = dateObj.toString();
        if (StringUtil.isBlank(format)) {
            format = DATE_FORMAT;
        }
        if (StringUtils.isBlank((String)dateStr) || dateStr.length() > format.length() && !lenient) {
            return null;
        }
        SimpleDateFormat sft = new SimpleDateFormat(format);
        sft.setLenient(lenient);
        if (!lenient && dateStr.length() > format.length()) {
            return null;
        }
        try {
            return sft.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u8bf7\u68c0\u67e5\u65f6\u95f4\u5bf9\u8c61\u683c\u5f0fformat\u662f\u5426\u7b26\u5408\u683c\u5f0f");
        }
    }

    public static Date long2Time(Object timeObj, String format) {
        if (DATE_FORMAT_LONG.equals(format)) {
            Long value = Long.valueOf(timeObj + "");
            return new Date(value);
        }
        if (DATE_FORMAT_LONG_1.equals(format)) {
            Long value = Long.valueOf(timeObj + "000");
            return new Date(value);
        }
        if (StringUtil.isNotBlank(format)) {
            return null;
        }
        String timeStr = timeObj + "";
        if (timeStr.length() < 12) {
            timeStr = timeStr + "000";
        }
        Long value = Long.valueOf(timeObj + "");
        return new Date(value);
    }

    public static boolean isTimeLong(Object timeObj, String format) {
        if (DATE_FORMAT_LONG.equals(format)) {
            return true;
        }
        if (DATE_FORMAT_LONG_1.equals(format)) {
            return true;
        }
        if (StringUtil.isNotBlank(format)) {
            return false;
        }
        if (timeObj instanceof Integer) {
            return true;
        }
        if (timeObj instanceof Long) {
            return true;
        }
        if (!(timeObj instanceof String)) {
            return false;
        }
        String timeStr = (String)timeObj;
        if (!NumberUtils.isIntegralNumber(timeStr)) {
            return false;
        }
        Long timeLong = Long.valueOf(timeStr);
        return timeLong > 1000000000L;
    }

    public static SimpleDateFormat getSimple(String format) {
        ThreadLocal<SimpleDateFormat> local = localMap.get(format);
        if (local == null) {
            return null;
        }
        SimpleDateFormat formatter = local.get();
        return formatter;
    }

    public static Object format2Date(Date date, String format) {
        if (DATE_FORMAT_LONG.equals(format)) {
            return date.getTime();
        }
        if (DATE_FORMAT_LONG_1.equals(format)) {
            return date.getTime() / 1000L;
        }
        if (StringUtil.isBlank(format)) {
            format = DATE_FORMAT;
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(date);
    }

    public static String getDiffDay(Date date, int diffDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, diffDay);
        Date resultTime = cal.getTime();
        return TimeUtil.format2Date(resultTime, DATE_FORMAT_2) + "";
    }

    public static Integer getDiffWithToday(String day, String format) {
        try {
            SimpleDateFormat sf = TimeUtil.getSimple(format);
            Date fromDate = sf.parse(day);
            Date today = new Date();
            long fromLong = fromDate.getTime();
            long todayLong = today.getTime();
            int days = (int)((fromLong - todayLong) / 86400000L);
            return days;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getDiffDay(Date date, int diffDay, String format) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, diffDay);
        Date resultTime = cal.getTime();
        return TimeUtil.format2Date(resultTime, format) + "";
    }

    public static boolean isMayTime(String time) {
        if (time == null) {
            return false;
        }
        String newTime = time.replace("-", "").replace(":", "").replace("/", "").replace(" ", "").replace(".", "");
        return NumberUtils.isNumeric(newTime);
    }

    public static String getValidDay(String newData) {
        String result = null;
        String month = newData.substring(0, newData.length() - 2);
        Date vsDate = DateUtils.StrToDate(month, DATE_FORMAT_6);
        String lastDay = DateUtils.getStrOfMonthLast(vsDate, DATE_FORMAT_2);
        Integer newDataInt = Integer.valueOf(newData);
        Integer lastDayInt = Integer.valueOf(lastDay);
        result = newDataInt > lastDayInt ? lastDay : newData;
        return result;
    }

    public static String getFormatedDateString(float timeZoneOffset) {
        int newTime;
        String[] ids;
        if (timeZoneOffset > 13.0f || timeZoneOffset < -12.0f) {
            timeZoneOffset = 0.0f;
        }
        TimeZone timeZone = (ids = TimeZone.getAvailableIDs(newTime = (int)(timeZoneOffset * 60.0f * 60.0f * 1000.0f))).length == 0 ? TimeZone.getDefault() : new SimpleTimeZone(newTime, ids[0]);
        SimpleDateFormat sdf = threadLocal.get();
        sdf.setTimeZone(timeZone);
        return sdf.format(new Date());
    }

    public static String getNewyorkTime() {
        return TimeUtil.getFormatedDateString(-5.0f);
    }

    public static void main(String[] args) {
        Long se = System.currentTimeMillis();
        System.out.println(se);
        System.out.println(se / 1000L);
        try {
            Date data = TimeUtil.format2Date("2018-08-17 10:40:00", DATE_FORMAT);
            System.out.println(data.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    static {
        localMap.put(DATE_FORMAT, threadLocal);
        localMap.put(DATE_FORMAT_1, threadLocal_1);
        localMap.put(DATE_FORMAT_2, threadLocal_2);
        localMap.put(DATE_FORMAT_3, threadLocal_3);
        localMap.put(DATE_FORMAT_4, threadLocal_4);
        localMap.put(DATE_FORMAT_5, threadLocal_5);
        localMap.put(DATE_FORMAT_6, threadLocal_6);
        localMap.put(DATE_FORMAT_7, threadLocal_7);
        localMap.put(DATE_FORMAT_8, threadLocal_8);
    }
}

