/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.CollectionUtils;
import com.manatee.common.util.StringUtil;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    private static final String EQUALS_SIGN = "=";
    private static final String AND_SIGN = "&";
    private static Log log = LogFactory.getLog(HttpRequestUtils.class);
    public static int TIME_OUT_IN_MILLISECONDS = 60000;
    protected static HttpClient httpClient = null;

    public static String httpPost(String url, Map<String, Object> body, Integer timeout) {
        return HttpRequestUtils.httpPost(url, null, body, timeout);
    }

    public static String httpPost(String url, Map<String, Object> header, Map<String, Object> body, Boolean isReturnNewHttpStructure, Integer timeout) {
        String result = HttpRequestUtils.httpPost(url, header, body, timeout);
        if (isReturnNewHttpStructure.booleanValue()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("statusCode", (Object)200);
            try {
                JSONObject object = JSONObject.parseObject((String)result);
                if (object.containsKey((Object)"status") && object.getInteger("status") != 200) {
                    jsonObject.put("statusCode", object.get((Object)"status"));
                    jsonObject.put("message", object.get((Object)"error"));
                } else {
                    jsonObject.put("responseEntity", (Object)object);
                }
            }
            catch (JSONException e) {
                try {
                    JSON json = (JSON)JSON.parse((String)result);
                    jsonObject.put("responseEntity", (Object)json);
                }
                catch (Exception ex) {
                    jsonObject.put("responseEntity", (Object)result);
                }
            }
            result = jsonObject.toString();
        }
        return result;
    }

    public static String httpPost(String url, Map<String, Object> header, List<Object> body, String key, Boolean isReturnNewHttpStructure, Integer timeout) {
        String result = HttpRequestUtils.httpPost(url, header, body, key, timeout);
        if (isReturnNewHttpStructure.booleanValue()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("statusCode", (Object)200);
            try {
                JSONObject object = JSONObject.parseObject((String)result);
                if (object.containsKey((Object)"status") && object.getInteger("status") != 200) {
                    jsonObject.put("statusCode", object.get((Object)"status"));
                    jsonObject.put("message", object.get((Object)"error"));
                } else {
                    jsonObject.put("responseEntity", (Object)object);
                }
            }
            catch (JSONException e) {
                try {
                    JSON json = (JSON)JSON.parse((String)result);
                    jsonObject.put("responseEntity", (Object)json);
                }
                catch (Exception ex) {
                    jsonObject.put("responseEntity", (Object)result);
                }
            }
            result = jsonObject.toString();
        }
        return result;
    }

    public static String httpPost(String url, Map<String, Object> header, Map<String, Object> body, Integer timeout) {
        String strResult = null;
        try {
            String formBody;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpRequestUtils.setTimeout(httpClient, timeout);
            HttpPost method = new HttpPost(url);
            url = URLDecoder.decode(url, "UTF-8");
            if (MapUtils.isNotEmpty(header)) {
                Header[] headers = new Header[header.size()];
                int num = 0;
                for (Map.Entry<String, Object> item : header.entrySet()) {
                    String name = item.getKey();
                    String value = (String)item.getValue();
                    BasicHeader h = new BasicHeader(name, value);
                    headers[num++] = h;
                }
                method.setHeaders(headers);
            }
            if (MapUtils.isNotEmpty(body) && !StringUtil.isBlank(formBody = HttpRequestUtils.generateRequestBody(body))) {
                StringEntity entity = new StringEntity(formBody, "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/x-www-form-urlencoded");
                method.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            strResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200) {
                log.warn((Object)("Http Status Error Of Post Method!, url:" + url + ", status code:" + statusCode + ", error msg:" + strResult));
            }
        }
        catch (Exception e) {
            log.error((Object)("Http Error of Post Method:, url:" + url), (Throwable)e);
        }
        return strResult;
    }

    public static String httpPost(String url, Map<String, Object> header, List<Object> body, String key, Integer timeout) {
        String strResult = null;
        try {
            String formBody;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpRequestUtils.setTimeout(httpClient, timeout);
            HttpPost method = new HttpPost(url);
            url = URLDecoder.decode(url, "UTF-8");
            if (MapUtils.isNotEmpty(header)) {
                Header[] headers = new Header[header.size()];
                int num = 0;
                for (Map.Entry<String, Object> item : header.entrySet()) {
                    String name = item.getKey();
                    String value = (String)item.getValue();
                    BasicHeader h = new BasicHeader(name, value);
                    headers[num++] = h;
                }
                method.setHeaders(headers);
            }
            if (CollectionUtils.isNotEmpty(body) && !StringUtil.isBlank(formBody = HttpRequestUtils.generateRequestBody(body, key))) {
                StringEntity entity = new StringEntity(formBody, "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/x-www-form-urlencoded");
                method.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            strResult = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200) {
                log.warn((Object)("Http Status Error Of Post Method!, url:" + url + ", status code:" + statusCode + ", error msg:" + strResult));
            }
        }
        catch (Exception e) {
            log.error((Object)("Http Error of Post Method:, url:" + url), (Throwable)e);
        }
        return strResult;
    }

    public static String httpGet(String url) {
        return HttpRequestUtils.httpGet(url, null);
    }

    public static String httpGet(String url, Map<String, Object> header) {
        String strResult = null;
        try {
            CloseableHttpResponse response;
            int statusCode;
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet method = new HttpGet(url);
            url = URLDecoder.decode(url, "UTF-8");
            if (MapUtils.isNotEmpty(header)) {
                ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
                for (Map.Entry<String, Object> item : header.entrySet()) {
                    String name = item.getKey();
                    String value = (String)item.getValue();
                    BasicHeader h = new BasicHeader(name, value);
                    headers.add(h);
                }
                method.setHeaders((Header[])headers.toArray());
            }
            if ((statusCode = (response = client.execute((HttpUriRequest)method)).getStatusLine().getStatusCode()) == 200) {
                strResult = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                log.warn((Object)("Http Status Error Of Get Method!, url:" + url + ", status code:" + statusCode));
            }
        }
        catch (Exception e) {
            log.error((Object)("Http Error of Get Method:, url:" + url), (Throwable)e);
        }
        return strResult;
    }

    public static String httpGet(String url, String proxyIp, int proxyPort, Map<String, Object> header) {
        String strResult = null;
        try {
            CloseableHttpResponse response;
            int statusCode;
            HttpGet method = new HttpGet(url);
            CloseableHttpClient client = HttpRequestUtils.setProxy(method, proxyIp, proxyPort);
            url = URLDecoder.decode(url, "UTF-8");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(1000).setSocketTimeout(3000).build();
            method.setConfig(requestConfig);
            if (MapUtils.isNotEmpty(header)) {
                ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
                for (Map.Entry<String, Object> item : header.entrySet()) {
                    String name = item.getKey();
                    String value = (String)item.getValue();
                    BasicHeader h = new BasicHeader(name, value);
                    headers.add(h);
                }
                method.setHeaders((Header[])headers.toArray());
            }
            if ((statusCode = (response = client.execute((HttpUriRequest)method)).getStatusLine().getStatusCode()) == 200) {
                strResult = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                log.warn((Object)("Http Status Error Of Get Method!, url:" + url + ", status code:" + statusCode));
            }
        }
        catch (Exception e) {
            log.error((Object)("Http Error of Get Method:, url:" + url), (Throwable)e);
        }
        return strResult;
    }

    private static CloseableHttpClient setProxy(HttpGet httpGet, String proxyIp, int proxyPort) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpHost proxy = new HttpHost(proxyIp, proxyPort, "http");
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxy).build();
        httpGet.setConfig(requestConfig);
        return httpClient;
    }

    public static String generateRequestBody(Map<String, Object> body) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> it = body.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Object value = body.get(key);
            if (it.hasNext()) {
                buffer.append(key).append(EQUALS_SIGN).append(value).append(AND_SIGN);
                continue;
            }
            buffer.append(key).append(EQUALS_SIGN).append(value);
        }
        return buffer.toString();
    }

    public static String generateRequestBody(List<Object> body, String key) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Object> iterator = body.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(key).append(EQUALS_SIGN).append(value).append(AND_SIGN);
                continue;
            }
            buffer.append(key).append(EQUALS_SIGN).append(value);
        }
        return buffer.toString();
    }

    public static String postDataByRequestBody(String url, String postData) {
        return HttpRequestUtils.postDataByRequestBody(url, postData, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postDataByRequestBody(String url, String postData, boolean needResponse, String responseCharsetName) {
        byte[] responseBody = null;
        HttpClient client = HttpRequestUtils.getHttpClient();
        PostMethod post = new PostMethod(url);
        try {
            String html = "";
            post.setRequestHeader("Content-type", "application/json; charset=utf-8");
            post.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
            post.getParams().setParameter("http.socket.timeout", (Object)TIME_OUT_IN_MILLISECONDS);
            post.setRequestBody(postData);
            client.executeMethod((HttpMethod)post);
            if (needResponse) {
                responseBody = post.getResponseBody();
                if (StringUtil.isBlank(responseCharsetName)) {
                    responseCharsetName = "utf-8";
                }
                html = new String(responseBody, responseCharsetName);
            }
            String string = html;
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)("postDataByRequestBody\u51fa\u9519,url=" + url + ",postData" + postData));
        }
        finally {
            post.releaseConnection();
        }
        return "";
    }

    public static HttpClient getHttpClient() {
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(TIME_OUT_IN_MILLISECONDS);
        return httpClient;
    }

    public static void setTimeout(DefaultHttpClient httpClient, Integer timeout) {
        if (timeout != null && timeout > 0) {
            httpClient.getParams().setIntParameter("http.socket.timeout", timeout.intValue());
        }
    }

    static {
        MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
        mgr.getParams().setDefaultMaxConnectionsPerHost(TIME_OUT_IN_MILLISECONDS);
        mgr.getParams().setMaxTotalConnections(200);
        httpClient = new HttpClient((HttpConnectionManager)mgr);
        httpClient.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.43 Safari/537.31");
    }
}

