/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util;

import com.manatee.common.util.StrUtils;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static final Pattern REGEX_NORM = Pattern.compile("\\d{4}-\\d{1,2}-\\d{1,2}(\\s\\d{1,2}:\\d{1,2}(:\\d{1,2})?)?(.\\d{1,3})?");
    public static final String NORM_MONTH_PATTERN = "yyyy-MM";
    public static final String SIMPLE_MONTH_PATTERN = "yyyyMM";
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String CHINESE_DATE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String CHINESE_DATE_TIME_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final String PURE_TIME_PATTERN = "HHmmss";
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final String PURE_DATETIME_MS_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String HTTP_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String JDK_DATETIME_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final String UTC_SIMPLE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String UTC_WITH_ZONE_OFFSET_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String UTC_MS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_MS_WITH_ZONE_OFFSET_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String nowDate() {
        long now = System.currentTimeMillis();
        return String.format("%tF", now);
    }

    public static String nowDate(String sper) {
        long now = System.currentTimeMillis();
        String s = String.format("%tF", now);
        String result = s.replaceAll("-", sper);
        return result;
    }

    public static String nowChDate() {
        GregorianCalendar Time2 = new GregorianCalendar();
        int nowY = Time2.get(1);
        int nowM = Time2.get(2) + 1;
        int nowD = Time2.get(5);
        return nowY + "\u5e74" + nowM + "\u6708" + nowD + "\u65e5";
    }

    public static String nowTime() {
        long now = System.currentTimeMillis();
        return String.format("%tT", now);
    }

    public static String nowTime(String sperate) {
        String s_time = DateUtils.nowTime();
        if (StrUtils.isNotEmpty((String)sperate)) {
            s_time = s_time.replaceAll(":", sperate);
        }
        return s_time;
    }

    public static String nowChTime() {
        String time = DateUtils.nowTime();
        String[] arr = time.split(":");
        return arr[0] + "\u65f6" + arr[1] + "\u5206" + arr[2] + "\u79d2";
    }

    public static String nowDateTime() {
        String s_DateTime = "";
        s_DateTime = DateUtils.nowDateTime("-", " ", ":");
        return s_DateTime;
    }

    public static String nowDateTime(String dateSpe, String midSpe, String timeSpe) {
        String s_DateTime = "";
        if (midSpe == null) {
            midSpe = " ";
        }
        s_DateTime = DateUtils.nowDate(dateSpe) + midSpe + DateUtils.nowTime(timeSpe);
        return s_DateTime;
    }

    public static String nowChDateTime() {
        String s_DateTime = "";
        s_DateTime = DateUtils.nowChDate() + " " + DateUtils.nowChTime();
        return s_DateTime;
    }

    public static String getNextDateOfDays(String date, int days) throws ParseException {
        date = DateUtils.formatDate(date, "/");
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        Date dt = format.parse(date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dt);
        cal.add(5, days);
        int nowY = cal.get(1);
        int nowM = cal.get(2) + 1;
        int nowD = cal.get(5);
        return nowY + StrUtils.leftPad(nowM, 2, '0') + StrUtils.leftPad(nowD, 2, '0');
    }

    public static int compareDate(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat(NORM_DATE_PATTERN);
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String getPreDateOfDays(String date, int days) throws ParseException {
        return DateUtils.getNextDateOfDays(date, -1 * days);
    }

    public static String formatDateTime(String dateTime) {
        return DateUtils.formatDateTime(dateTime, "-", " ", ":");
    }

    public static String formatDateTime(String dateTime, String dateSpe, String midSpe, String timeSpe) {
        String s = dateTime;
        if (StrUtils.isNotEmpty((String)dateTime) && dateTime.length() >= 14) {
            dateSpe = dateSpe == null ? "-" : dateSpe.trim();
            if (midSpe == null) {
                midSpe = " ";
            }
            timeSpe = timeSpe == null ? ":" : timeSpe.trim();
            s = dateTime.substring(0, 4) + dateSpe + dateTime.substring(4, 6) + dateSpe + dateTime.substring(6, 8) + midSpe + dateTime.substring(8, 10) + timeSpe + dateTime.substring(10, 12) + timeSpe + dateTime.substring(12, 14);
            if (dateTime.length() == 17) {
                s = s + timeSpe + dateTime.substring(14, 17);
            }
        }
        return s;
    }

    public static String formatChDateTime(String dateTime) {
        String s = "";
        if (StrUtils.isNotEmpty((String)dateTime) && dateTime.length() >= 14) {
            s = dateTime.substring(0, 4) + "\u5e74" + dateTime.substring(4, 6) + "\u6708" + dateTime.substring(6, 8) + "\u65e5 " + dateTime.substring(8, 10) + "\u65f6" + dateTime.substring(10, 12) + "\u5206" + dateTime.substring(12, 14) + "\u79d2";
            if (dateTime.length() == 17) {
                s = s + dateTime.substring(14, 17) + "\u6beb\u79d2";
            }
        }
        return s;
    }

    public static String formatDate(String date) {
        return DateUtils.formatDate(date, "-");
    }

    public static String formatDate(String date, String dateSpe) {
        String s = date;
        if (StrUtils.isNotEmpty((String)date) && date.length() == 8) {
            dateSpe = dateSpe == null ? "-" : dateSpe.trim();
            s = date.substring(0, 4) + dateSpe + date.substring(4, 6) + dateSpe + date.substring(6, 8);
        }
        return s;
    }

    public static String formatChDate(String date) {
        String s = date;
        if (StrUtils.isNotEmpty((String)date) && date.length() == 8) {
            s = date.substring(0, 4) + "\u5e74" + date.substring(4, 6) + "\u6708" + date.substring(6, 8) + "\u65e5";
        }
        return s;
    }

    public static String formatTime(String time) {
        return DateUtils.formatTime(time, ":");
    }

    public static String formatTime(String time, String timeSpe) {
        String s = time;
        if (StrUtils.isNotEmpty((String)time) && time.length() >= 6) {
            timeSpe = timeSpe == null ? ":" : timeSpe.trim();
            s = time.substring(0, 2) + timeSpe + time.substring(2, 4) + timeSpe + time.substring(4, 6);
            if (time.length() == 9) {
                s = s + timeSpe + time.substring(6, 9);
            }
        }
        return s;
    }

    public static String formatChTime(String time) {
        String s = time;
        if (StrUtils.isNotEmpty((String)time) && time.length() >= 6) {
            s = time.substring(0, 2) + "\u65f6" + time.substring(2, 4) + "\u5206" + time.substring(4, 6) + "\u79d2";
            if (time.length() == 9) {
                s = s + time.substring(6, 9) + "\u6beb\u79d2";
            }
        }
        return s;
    }

    public static String normalizeDate(String date) {
        String s = date;
        if (StrUtils.isNotEmpty((String)date) && date.length() != 8) {
            s = date.replaceAll("-", "");
        }
        return s;
    }

    public static String normalizeDateTime(String dateTime) {
        String s = dateTime;
        if (StrUtils.isNotEmpty((String)dateTime) && dateTime.length() != 14) {
            s = dateTime.replaceAll("-", "");
            s = s.replaceAll(":", "");
            s = s.replaceAll(" ", "");
        }
        return s;
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df1 = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        return df1.format(date);
    }

    public static double getNumberOfDaysTimes(String fromDate, String toDate) {
        String strFromDate = "";
        String strToDate = "";
        if (fromDate.length() == 8) {
            strFromDate = DateUtils.formatDate(fromDate, "/");
        } else if (fromDate.length() == 14) {
            strFromDate = DateUtils.formatDateTime(fromDate, "/", " ", ":");
        }
        if (toDate.length() == 8) {
            strToDate = DateUtils.formatDate(toDate, "/");
        } else if (toDate.length() == 14) {
            strToDate = DateUtils.formatDateTime(toDate, "/", " ", ":");
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date dt1 = null;
        Date dt2 = null;
        try {
            dt1 = df1.parse(strToDate);
            dt2 = df1.parse(strFromDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double days = dt1.getTime() - dt2.getTime();
        return days / 60.0 / 60.0 / 1000.0 / 24.0;
    }

    public static int getNumberOfDays(String fromDate, String toDate) {
        double days = DateUtils.getNumberOfDaysTimes(fromDate, toDate);
        return (int)days;
    }

    public static double getDecimalDays(double days, int workHours) {
        double result = 0.0;
        if ((double)((int)days) == days) {
            return days;
        }
        int idays = (int)days;
        double hours = (double)workHours / 48.0;
        double d = (double)idays + hours;
        result = days >= d ? (double)idays + 1.0 : (double)idays + 0.5;
        return result;
    }

    public static Timestamp nowTimestamp() {
        SimpleDateFormat df1 = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        Date date11 = new Date();
        String time = df1.format(date11);
        Timestamp ts = Timestamp.valueOf(time);
        return ts;
    }

    public static Timestamp getTimestamp(String StrDate) {
        String[] tss = StrDate.split(".");
        String t = "";
        String s = "";
        if (tss.length > 0) {
            t = tss[0];
            s = tss[1];
        } else {
            t = StrDate;
        }
        SimpleDateFormat df1 = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        Date d = null;
        Timestamp ts = null;
        try {
            d = df1.parse(t);
            String time = df1.format(d);
            ts = Timestamp.valueOf(time + s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Date getDateMinute(Date date, Integer minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static Date getDateHour(Date date, Integer hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, hours);
        return calendar.getTime();
    }

    public static Date GetDateDiff(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static String GetDateDiffToStr(Date date, Integer days, String pattern) {
        if (pattern == null) {
            pattern = NORM_DATE_PATTERN;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(calendar.getTime());
    }

    public static Date getDateMonthDiff(Date date, Integer months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date getDateYearDiff(Date date, Integer years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static String DateToStr(Date date, String Format2, String zone) {
        if (StrUtils.GetString(Format2).equals("")) {
            Format2 = NORM_DATETIME_PATTERN;
        }
        SimpleDateFormat format = new SimpleDateFormat(Format2);
        format.setTimeZone(TimeZone.getTimeZone(zone));
        String str = format.format(date);
        return str;
    }

    public static String DateToStr(Date date, String Format2) {
        if (StrUtils.GetString(Format2).equals("")) {
            Format2 = NORM_DATETIME_PATTERN;
        }
        SimpleDateFormat format = new SimpleDateFormat(Format2);
        String str = format.format(date);
        return str;
    }

    public static Date StrToDate(String str, String Format2) {
        if (StrUtils.GetString(Format2).equals("")) {
            Format2 = NORM_DATETIME_PATTERN;
        }
        str = StrUtils.isEmpty((String)str) ? DateUtils.nowDate() : str;
        SimpleDateFormat format = new SimpleDateFormat(Format2);
        Date date = null;
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getDateTime(int hours, String flag) {
        SimpleDateFormat df1 = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        Calendar c = Calendar.getInstance();
        if (StrUtils.isEmpty((String)flag) || "before".equalsIgnoreCase(flag)) {
            c.add(11, -1 * hours);
        } else {
            c.add(11, 1 * hours);
        }
        return df1.format(c.getTime());
    }

    public static String getHMS(long millisecond) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        long hour = millisecond / (long)hh;
        long minute = (millisecond - hour * (long)hh) / (long)mi;
        long second = (millisecond - hour * (long)hh - minute * (long)mi) / (long)ss;
        long millis = millisecond - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String hms = strHour + ":" + strMinute + ":" + strSecond + "." + millis;
        return hms;
    }

    public static Date getDateOfMonthFirst(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static String getStrOfMonthFirst(Date date, String formatStr) {
        return DateUtils.DateToStr(DateUtils.getDateOfMonthFirst(date), StringUtils.isBlank((String)formatStr) ? NORM_DATE_PATTERN : formatStr);
    }

    public static Date getDateOfMonthLast(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        return c.getTime();
    }

    public static String getStrOfMonthLast(Date date, String formatStr) {
        return DateUtils.DateToStr(DateUtils.getDateOfMonthLast(date), StringUtils.isBlank((String)formatStr) ? NORM_DATE_PATTERN : formatStr);
    }

    public static Date getDateAddWithType(Date date, int type, int num) {
        if (null == date) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(type, num);
        return c.getTime();
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTime(date);
        }
        return c.get(1);
    }

    public static String getWeekCh() {
        long now = System.currentTimeMillis();
        return String.format("%tA", now);
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7);
        return week;
    }

    public static boolean isMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7);
        return week == 2;
    }

    public static boolean isFriday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7);
        return week == 6;
    }

    public static boolean isSaturday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7);
        return week == 7;
    }

    public static boolean isSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week = cal.get(7);
        return week == 1;
    }

    public static Date getWeekStart(Date date) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(date);
        currentDate.set(7, 2);
        return currentDate.getTime();
    }

    public static Date getWeekEnd(Date date) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(date);
        currentDate.set(7, 7);
        return currentDate.getTime();
    }

    public static Date getWeekFRI(Date date) {
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(date);
        currentDate.set(7, 6);
        return currentDate.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static Date getMaxDayOfMonth(Date date) {
        String strdate = DateUtils.DateToStr(date, NORM_MONTH_PATTERN);
        Date datemonth = DateUtils.StrToDate(strdate, NORM_MONTH_PATTERN);
        Calendar cal = Calendar.getInstance();
        cal.setTime(datemonth);
        cal.set(5, cal.getActualMaximum(5));
        date = cal.getTime();
        return date;
    }

    public static Date getUSDate(Date date) {
        SimpleDateFormat sdfe = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        sdfe.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        Date us_date = DateUtils.StrToDate(sdfe.format(date), NORM_DATETIME_PATTERN);
        return us_date;
    }

    public static String getUSDateStr(Date date) {
        SimpleDateFormat sdfe = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        sdfe.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        return sdfe.format(date);
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_count = cal.get(3);
        cal.add(5, -7);
        int last_week = cal.get(3);
        if (week_count < last_week) {
            week_count = last_week + 1;
        }
        return week_count;
    }

    public static boolean isToday(String date) {
        String strnow = DateUtils.DateToStr(new Date(), NORM_DATE_PATTERN);
        return strnow.equals(date);
    }

    public static int daysBetween(Date smdate, Date bdate) {
        String format = NORM_DATE_PATTERN;
        String str_d1 = DateUtils.DateToStr(smdate, format);
        String str_d2 = DateUtils.DateToStr(bdate, format);
        smdate = DateUtils.StrToDate(str_d1, format);
        bdate = DateUtils.StrToDate(str_d2, format);
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date convertTimeZoneToUS(Date date) {
        SimpleDateFormat sdfe = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        sdfe.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        Date us_date = DateUtils.StrToDate(sdfe.format(date), NORM_DATETIME_PATTERN);
        return us_date;
    }

    public static String convertTimeZoneToStrUS(Date date) {
        SimpleDateFormat sdfe = new SimpleDateFormat(NORM_DATETIME_PATTERN);
        sdfe.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        return sdfe.format(date);
    }

    public static Date TimeZoneToUS(Date date) {
        TimeZone srcTimeZone = TimeZone.getTimeZone("GMT+8");
        TimeZone destTimeZone = TimeZone.getTimeZone("America/New_York");
        Date cdate = DateUtils.dateTransformBetweenTimeZone(date, srcTimeZone, destTimeZone);
        return cdate;
    }

    public static String TimeZoneToStrUS(Date date) {
        TimeZone srcTimeZone = TimeZone.getTimeZone("GMT+8");
        TimeZone destTimeZone = TimeZone.getTimeZone("America/New_York");
        Date cdate = DateUtils.dateTransformBetweenTimeZone(date, srcTimeZone, destTimeZone);
        return DateUtils.DateToStr(cdate, NORM_DATETIME_PATTERN);
    }

    public static Date convertTimeZoneToCH(Date date) {
        TimeZone srcTimeZone = TimeZone.getTimeZone("America/New_York");
        TimeZone destTimeZone = TimeZone.getTimeZone("GMT+8");
        Date cdate = DateUtils.dateTransformBetweenTimeZone(date, srcTimeZone, destTimeZone);
        return cdate;
    }

    public static String convertTimeZoneToStrCH(Date date) {
        TimeZone srcTimeZone = TimeZone.getTimeZone("America/New_York");
        TimeZone destTimeZone = TimeZone.getTimeZone("GMT+8");
        Date cdate = DateUtils.dateTransformBetweenTimeZone(date, srcTimeZone, destTimeZone);
        return DateUtils.DateToStr(cdate, NORM_DATETIME_PATTERN);
    }

    private static Date dateTransformBetweenTimeZone(Date sourceDate, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        Long targetTime = sourceDate.getTime() - (long)sourceTimeZone.getRawOffset() + (long)targetTimeZone.getRawOffset();
        return new Date(targetTime);
    }

    public static String getNetDate() {
        URLConnection uc = null;
        try {
            URL url = new URL("http://www.beijing-time.org");
            uc = url.openConnection();
            uc.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Date date = new Date();
        if (uc != null) {
            long ld = uc.getDate();
            date = new Date(ld);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(NORM_DATETIME_PATTERN, Locale.CHINA);
        return sdf.format(date);
    }

    public static long calDateDiff(String dateStr1, String dateStr2, String type) {
        String format = NORM_DATE_PATTERN;
        return DateUtils.calDateDiff(dateStr1, dateStr2, type, format);
    }

    public static long calDateDiff(String dateStr1, String dateStr2, String type, String format) {
        long dates = 0L;
        long d1 = DateUtils.getLongDate(dateStr1, format);
        long d2 = DateUtils.getLongDate(dateStr2, format);
        if ("hour".equals(type)) {
            long days;
            dates = days = (d1 - d2) / 3600000L;
        } else if ("day".equals(type)) {
            long days;
            dates = days = (d1 - d2) / 86400000L;
        } else if ("month".equals(type)) {
            long months;
            dates = months = (d1 - d2) / 2592000000L;
        } else if ("year".equals(type)) {
            long years;
            dates = years = (d1 - d2) / 31104000000L;
        }
        return dates;
    }

    private static long getLongDate(String dateStr1, String farmat) {
        long d1 = "now".equals(dateStr1) ? System.currentTimeMillis() : DateUtils.StrToDate(dateStr1, farmat).getTime();
        return d1;
    }

    public static String showTime(Date ctime, String format) {
        Map<String, String> desMap = DateUtils.getDescMap();
        String r = "";
        if (ctime == null) {
            return r;
        }
        if (format == null) {
            format = "MM-dd HH:mm";
        }
        long nowtimelong = System.currentTimeMillis();
        long ctimelong = ctime.getTime();
        long seconds = Math.abs(nowtimelong - ctimelong) / 1000L;
        r = DateUtils.getShowDate(ctime, format, desMap, seconds);
        return r;
    }

    private static String getShowDate(Date ctime, String format, Map<String, String> desMap, long seconds) {
        String r;
        if (seconds < 60L) {
            r = seconds == 0L ? desMap.get("just") : seconds + desMap.get("seconds_ago");
        } else if (seconds < 3600L) {
            long minutes = seconds / 60L;
            r = minutes + desMap.get("minutes_ago");
        } else if (seconds < 86400L) {
            long hours = seconds / 3600L;
            r = hours + desMap.get("hours_ago");
        } else if (seconds < 172800L) {
            long days = seconds / 86400L;
            r = days + desMap.get("days_ago");
        } else {
            SimpleDateFormat df = new SimpleDateFormat(format);
            r = df.format(ctime);
        }
        return r;
    }

    private static Map<String, String> getDescMap() {
        HashMap<String, String> desMap = new HashMap<String, String>();
        desMap.put("just", "\u521a\u521a");
        desMap.put("seconds_ago", "\u79d2\u524d");
        desMap.put("minutes_ago", "\u5206\u949f\u524d");
        desMap.put("hours_ago", "\u5c0f\u65f6\u524d");
        desMap.put("days_ago", "\u5929\u524d");
        return desMap;
    }

    public static void main(String[] args) {
        int i = DateUtils.compareDate("1995-11-12 15:21", "1993-12-11 09:59");
        System.out.println("i==" + i);
        System.out.println(DateUtils.DateToStr(new Date(1507831840000L), "", "GMT"));
    }
}

