/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryTaskProcess
implements IProcess {
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    protected IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        List list;
        String userId = this.variableUtil.calVarInConf(content, "userId");
        String processInstanceIds = this.variableUtil.calVarInConf(content, "processInstanceIds");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (StrUtil.isNotBlank((CharSequence)processInstanceIds)) {
            String[] processInstanceIdsArr = processInstanceIds.split(",");
            taskQuery.processInstanceIdIn(processInstanceIdsArr);
        }
        if ((list = taskQuery.list()) != null) {
            ArrayList<Task> addSignerTasks = new ArrayList<Task>();
            HashSet<String> beforeAddSignerParentTaskIds = new HashSet<String>();
            HashSet<String> afterAddSignerParentTaskIds = new HashSet<String>();
            HashSet<String> finishParentTaskIds = new HashSet<String>();
            HashSet<String> toBeFinishParentTaskIds = new HashSet<String>();
            for (Task task : list) {
                if (!StringUtils.isNotBlank((CharSequence)task.getParentTaskId())) continue;
                addSignerTasks.add(task);
                Object addSignerType = this.taskService.getVariableLocal(task.getId(), "ADD_SIGNER_TYPE");
                if (addSignerType != null && StrUtil.equals((CharSequence)addSignerType.toString(), (CharSequence)"before")) {
                    beforeAddSignerParentTaskIds.add(task.getParentTaskId());
                    continue;
                }
                if (addSignerType == null || !StrUtil.equals((CharSequence)addSignerType.toString(), (CharSequence)"after")) continue;
                afterAddSignerParentTaskIds.add(task.getParentTaskId());
                if (finishParentTaskIds.contains(task.getParentTaskId()) || toBeFinishParentTaskIds.contains(task.getParentTaskId())) continue;
                Object status = this.taskService.getVariableLocal(task.getId(), "MANATEE_TASK_ADD_SIGNER_STATUS");
                if (status != null && StrUtil.equals((CharSequence)status.toString(), (CharSequence)BpmTaskStatusEnum.APPROVE.getStatus().toString())) {
                    finishParentTaskIds.add(task.getParentTaskId());
                    continue;
                }
                toBeFinishParentTaskIds.add(task.getParentTaskId());
            }
            for (int i = 0; i < list.size(); ++i) {
                Task task;
                task = (Task)list.get(i);
                String id = task.getId();
                if (StrUtil.isNotBlank((CharSequence)userId) && !StrUtil.equals((CharSequence)task.getAssignee(), (CharSequence)userId)) {
                    list.remove(i);
                    --i;
                    continue;
                }
                if (beforeAddSignerParentTaskIds.contains(id)) {
                    list.remove(i);
                    --i;
                    continue;
                }
                if (afterAddSignerParentTaskIds.contains(id) && finishParentTaskIds.contains(id)) {
                    list.remove(i);
                    --i;
                    continue;
                }
                String parentTaskId = task.getParentTaskId();
                if (!afterAddSignerParentTaskIds.contains(parentTaskId) || !toBeFinishParentTaskIds.contains(parentTaskId)) continue;
                list.remove(i);
                --i;
            }
        }
        String jsonString = JSONUtil.toJsonStr((Object)list);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryTask";
    }
}

