/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task;

import com.alibaba.fastjson.JSONObject;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.camunda.process.task.handle.BackToPreviousNodeTaskHandle;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.lowcode.iutil.IInputUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.DatatypeConverter;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaCompleteTaskProcess
implements IProcess {
    private Logger log = LoggerFactory.getLogger(BackToPreviousNodeTaskHandle.class);
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Resource
    private IInputUtil inputUtil;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private Map<String, TaskHandle> taskHandleMap;

    public void process(ProcessContent content) throws BizException {
        TaskHandle taskHandle;
        String processInstanceId;
        String userId = this.getOneVarValue(content, "userId");
        String taskId = this.getOneVarValue(content, "taskId");
        String message = this.getOneVarValue(content, "message");
        Map variables = this.inputUtil.getHandleObject(content, "dataHandle");
        String targetTaskId = this.getOneVarValue(content, "targetNode");
        if (StringUtil.isBlank((String)userId) || StringUtil.isBlank((String)taskId)) {
            return;
        }
        String attachmentsKey = this.variableUtil.calVarInConf(content, "attachments");
        List attachments = (List)content.getValue(attachmentsKey);
        String auditResult = this.variableUtil.calVarInConf(content, "auditResult");
        if (StringUtil.isBlank((String)auditResult)) {
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u8bf7\u9009\u62e9\u4efb\u52a1\u5ba1\u6838\u7ed3\u679c");
        }
        Task task = null;
        HistoricTaskInstance historicTaskInstance = null;
        if (auditResult.equals("withdraw")) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
            if (historicTaskInstance == null) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
            }
            processInstanceId = historicTaskInstance.getProcessInstanceId();
        } else {
            task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            if (task == null) {
                throw new BizException(ResultCode.SYSTEM_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
            }
            if (!auditResult.equalsIgnoreCase("claim") && task.getAssignee() != null && !task.getAssignee().equals(userId)) {
                throw new BizException(ResultCode.NOT_AUTHORIZED, "\u7528\u6237\u65e0\u6743\u9650,\u65e0\u6cd5\u5ba1\u6279");
            }
            processInstanceId = task.getProcessInstanceId();
        }
        if (StringUtil.isBlank((String)message)) {
            message = "";
        }
        if (task != null) {
            Map oldVariables = this.taskService.getVariables(task.getId());
            oldVariables.putAll(variables);
            this.taskService.setVariables(task.getId(), variables);
        }
        if ((taskHandle = this.taskHandleMap.get(auditResult + "TaskHandle")) == null) {
            this.log.error(" auditResult: {}, taskHandleMapKey:{}", (Object)auditResult, this.taskHandleMap.keySet());
            throw new BizException(ResultCode.BIZ_ERROR, "\u5904\u7406\u5668\u914d\u7f6e\u9519\u8bef\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        ArrayList<String> addSignerProcessor = new ArrayList();
        String addSignerProcessorKey = this.variableUtil.calVarInConf(content, "processor");
        if (StringUtil.isNotBlank((String)addSignerProcessorKey)) {
            Object userIdsObject = content.getValue(addSignerProcessorKey);
            if (userIdsObject instanceof List) {
                addSignerProcessor = (List)userIdsObject;
            } else if (userIdsObject instanceof String) {
                if (userIdsObject.toString().contains(",")) {
                    addSignerProcessor = Arrays.asList(userIdsObject.toString().split(","));
                } else {
                    addSignerProcessor.add(userIdsObject.toString());
                }
            }
        }
        String nodeName = this.getOneVarValue(content, "nodeName");
        String addSignerType = this.variableUtil.calVarInConf(content, "addSignerType");
        String processorType = this.variableUtil.calVarInConf(content, "processorType");
        TaskDTO taskDTO = taskHandle.buildTaskDTO(taskId, userId, processInstanceId, message, task, variables, addSignerProcessor, nodeName, addSignerType, processorType, content);
        taskDTO.setTargetTaskId(targetTaskId);
        taskDTO.setAttachments(attachments);
        JSONObject result = taskHandle.handle(taskDTO);
        this.outputUtil.setDefaultReturnKey(content, "outputData");
        this.outputUtil.putData(content, (Object)result);
    }

    private void setAddSignHisPass(String taskId, JSONObject taskAddSignerNodeInfo) {
        if (taskAddSignerNodeInfo == null) {
            return;
        }
        String taskDefKey = taskAddSignerNodeInfo.getString("taskDefKey");
        Object taskAddSignerHisNodeInfoList = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        if (taskAddSignerHisNodeInfoList == null) {
            taskAddSignerHisNodeInfoList = new ArrayList();
        }
        for (Object subTaskInfoObj : taskAddSignerHisNodeInfoList) {
            JSONObject subTaskInfo;
            if (subTaskInfoObj == null || !(subTaskInfo = (JSONObject)subTaskInfoObj).get((Object)"taskDefKey").equals(taskDefKey)) continue;
            subTaskInfo.put("status", (Object)BpmTaskStatusEnum.APPROVE.getStatus());
        }
        this.taskService.setVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerHisNodeInfoList));
    }

    private void setAllAddSignHisPass(String taskId) {
        Object taskAddSignerHisNodeInfoList = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        if (taskAddSignerHisNodeInfoList == null) {
            taskAddSignerHisNodeInfoList = new ArrayList();
        }
        for (Object subTaskInfoObj : taskAddSignerHisNodeInfoList) {
            if (subTaskInfoObj == null) continue;
            JSONObject subTaskInfo = (JSONObject)subTaskInfoObj;
            subTaskInfo.put("status", (Object)BpmTaskStatusEnum.APPROVE.getStatus());
        }
        this.taskService.setVariableLocal(taskId, "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerHisNodeInfoList));
    }

    private String hashDefKeyName() {
        String s = IdUtil.fastSimpleUUID();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = messageDigest.digest(s.getBytes());
            String hash = DatatypeConverter.printHexBinary((byte[])hashBytes);
            return hash.substring(0, 10);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return s;
        }
    }

    private String getOneVarValue(ProcessContent content, String varKey) {
        Object varValueObj;
        String varKeyValue = this.variableUtil.calVarInConf(content, varKey);
        String varValue = null;
        if (StringUtil.isNotBlank((String)varKeyValue) && (varValueObj = content.getValue(varKeyValue)) != null) {
            varValue = varValueObj.toString();
        }
        return varValue;
    }

    public String getName() {
        return "camundaCompleteTask";
    }
}

