/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.runtime;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryInstanceProcess
implements IProcess {
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private TaskService taskService;
    @Resource
    private VariableUtil variableUtil;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;

    public void process(ProcessContent content) throws BizException {
        String processDefinitionKey = this.variableUtil.calVarInConf(content, "prcesssKey");
        Object processInstanceId = this.variableUtil.calVarInContent(content, "processInstanceId", null);
        Object taskId = this.variableUtil.calVarInContent(content, "taskId", null);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        if (StrUtil.isNotBlank((CharSequence)processDefinitionKey)) {
            String[] keys = processDefinitionKey.split(",");
            processInstanceQuery.processDefinitionKeyIn(keys);
        }
        if (taskId != null && StrUtil.isNotBlank((CharSequence)taskId.toString())) {
            TaskQuery taskQuery = this.taskService.createTaskQuery().taskId(taskId.toString().trim());
            Task task = (Task)taskQuery.singleResult();
            if (task != null) {
                processInstanceQuery.processInstanceId(task.getProcessInstanceId());
            } else {
                HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceQuery.taskId(taskId.toString().trim()).singleResult();
                if (historicTaskInstance != null) {
                    processInstanceQuery.processInstanceId(historicTaskInstance.getProcessInstanceId());
                } else {
                    this.outputUtil.putData(content, null);
                    return;
                }
            }
        }
        if (processInstanceId != null && StrUtil.isNotBlank((CharSequence)processInstanceId.toString())) {
            processInstanceQuery.processInstanceId(processInstanceId.toString().trim());
        }
        List list = processInstanceQuery.list();
        String jsonString = JSONUtil.toJsonStr((Object)list);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryInstanceProcess";
    }
}

