/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.repository;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.ArrayUtil;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryDeploymentProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private InputUtil inputUtil;

    public void process(ProcessContent content) throws BizException {
        List processDefinitions;
        Object prcesssKeys;
        String pageStr = this.variableUtil.calVarInConf(content, "pageNum");
        String pageSizeStr = this.variableUtil.calVarInConf(content, "pageSize");
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId();
        Object data = this.inputUtil.getData(content, "deploymentIds");
        if (data != null) {
            List dataList = (List)data;
            String[] ids = (String[])ArrayUtil.toArray((Collection)dataList, String.class);
            processDefinitionQuery.processDefinitionIdIn(ids);
        }
        if ((prcesssKeys = this.inputUtil.getData(content, "prcesssKeys")) != null) {
            List prcesss = (List)prcesssKeys;
            String[] keys = (String[])ArrayUtil.toArray((Collection)prcesss, String.class);
            processDefinitionQuery.processDefinitionKeysIn(keys);
            processDefinitionQuery.latestVersion();
        }
        if (StrUtil.isNotBlank((CharSequence)pageStr) && StrUtil.isNotBlank((CharSequence)pageSizeStr)) {
            int pageSize = Integer.parseInt(pageSizeStr);
            int page = 1;
            if (StrUtil.isNotBlank((CharSequence)pageStr) && NumberUtil.isNumber((CharSequence)pageStr)) {
                page = Integer.parseInt(pageStr);
            }
            int firstResult = (page - 1) * pageSize;
            processDefinitions = processDefinitionQuery.listPage(firstResult, firstResult + pageSize);
        } else {
            processDefinitions = ((ProcessDefinitionQuery)processDefinitionQuery.asc()).list();
        }
        String jsonString = JSONUtil.toJsonStr((Object)processDefinitions);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryDeploymentProcess";
    }
}

