/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.history;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.NumberUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.json.JSONUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.springframework.stereotype.Service;

@Service
public class CamundaQueryInstanceInfoProcess
implements IProcess {
    @Resource
    private HistoryService historyService;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private VariableUtil variableUtil;
    @Resource
    private InputUtil inputUtil;

    public void process(ProcessContent content) throws BizException {
        List historicProcessInstance;
        String key;
        JSONObject dataList;
        JSONArray processInstanceIds;
        HashSet ids;
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        String pageStr = this.variableUtil.calVarInConf(content, "pageNum");
        String pageSizeStr = this.variableUtil.calVarInConf(content, "pageSize");
        Object data = this.inputUtil.getHandleData(content, "processInstanceIds");
        if (data != null && !(ids = new HashSet((processInstanceIds = (dataList = (JSONObject)data).getJSONArray(key = content.getStepConf().getString("processInstanceIds"))).toJavaList(String.class))).isEmpty()) {
            historicProcessInstanceQuery.processInstanceIds(ids);
        }
        if (StrUtil.isNotBlank((CharSequence)pageStr) && StrUtil.isNotBlank((CharSequence)pageSizeStr)) {
            int pageSize = Integer.parseInt(pageSizeStr);
            int page = 1;
            if (StrUtil.isNotBlank((CharSequence)pageStr) && NumberUtil.isNumber((CharSequence)pageStr)) {
                page = Integer.parseInt(pageStr);
            }
            int firstResult = (page - 1) * pageSize;
            historicProcessInstance = historicProcessInstanceQuery.listPage(firstResult, firstResult + pageSize);
        } else {
            historicProcessInstance = historicProcessInstanceQuery.list();
        }
        String jsonString = JSONUtil.toJsonStr((Object)historicProcessInstance);
        this.outputUtil.putData(content, JSONObject.parse((String)jsonString));
    }

    public String getName() {
        return "camundaQueryInstanceInfoProcess";
    }
}

