/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.dmn;

import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import javax.annotation.Resource;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.springframework.stereotype.Service;

@Service
public class CamundaDmnDeploymentProcess
implements IProcess {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IOutputUtil outputUtil;

    public void process(ProcessContent content) throws BizException {
        String dmn = this.variableUtil.calVarInConf(content, "processDmn");
        String pic = this.variableUtil.calVarInConf(content, "processBpmnPic");
        if (StrUtil.isBlank((CharSequence)pic)) {
            pic = "";
        }
        String name = this.variableUtil.calVarInConf(content, "processDmnName");
        Deployment deploy = this.repositoryService.createDeployment().addString("manatee.dmn", dmn).addString("manatee.dmn.svg", pic).name(name).deploy();
        this.outputUtil.putData(content, (Object)deploy.getId());
    }

    public String getName() {
        return "camundaDmnDeploymentProcess";
    }
}

