/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.base;

import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DmCamunda
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger log = LogManager.getLogger(DmCamunda.class);
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private ConfigurableEnvironment environment;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Environment env = (Environment)beanFactory.getBean(ConfigurableEnvironment.class);
        String driver = env.getProperty("spring.datasource.driver-class-name");
        if (driver != null && driver.contains("dm")) {
            ((ConfigurableEnvironment)env).getPropertySources().addFirst((PropertySource)new MapPropertySource("early-init", Collections.singletonMap("camunda.bpm.database.type", "oracle")));
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

