/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.util;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.exp.syntax.ManateeSyntax;
import com.manatee.process.util.StringUtil;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ExpressionUtil {
    public static Map<String, String> symbolMap = new ConcurrentHashMap<String, String>();

    public static Map<Integer, Integer> getBracketsMapping(String a) {
        int n;
        Stack<Integer> stack = new Stack<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = n = 0;
        while (n2 < a.length()) {
            if (a.charAt(n) == '(') {
                stack.add(n + 1);
                hashMap.put(n, null);
            } else if (a.charAt(n) == ')') {
                int n3 = (Integer)stack.pop();
                if (n3 > 0) {
                    hashMap.put(n3 - 1, n);
                } else if (n3 == 0) {
                    stack.add(0);
                }
            }
            n2 = ++n;
        }
        return hashMap;
    }

    public static List<String> getConditionList(String a) {
        String string = a;
        List<String> list = ExpressionUtil.getBracketsMapping(string).entrySet();
        HashSet<Map.Entry> hashSet = new HashSet<Map.Entry>();
        for (Map.Entry entry : list) {
            Integer n = (Integer)entry.getKey();
            Integer n2 = (Integer)entry.getValue();
            if (n == 0) {
                string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
                string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
                hashSet.add(entry);
                continue;
            }
            if (n <= 0) continue;
            String string2 = ExpressionUtil.ALLATORIxDEMO(string, n);
            if (!StringUtil.ALLATORIxDEMO("-").equals(string2) && !ManateeSyntax.ALLATORIxDEMO("(").equals(string2) && !"|".equals(string2)) continue;
            string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
            string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
            hashSet.add(entry);
        }
        string = string.trim();
        string = string.replaceAll(StringUtil.ALLATORIxDEMO("'#"), ManateeSyntax.ALLATORIxDEMO("\"y\""));
        string = string.replaceAll(StringUtil.ALLATORIxDEMO("#"), ManateeSyntax.ALLATORIxDEMO("\"y\""));
        string = string.replaceAll(StringUtil.ALLATORIxDEMO("]y]y"), ManateeSyntax.ALLATORIxDEMO("\"y\""));
        string = string.replaceAll("\\|", StringUtil.ALLATORIxDEMO(")-)"));
        list = Arrays.asList(StrUtil.split((CharSequence)string, (CharSequence)ManateeSyntax.ALLATORIxDEMO("\"y\"")));
        return list;
    }

    static {
        symbolMap.put(ManateeSyntax.ALLATORIxDEMO("&"), StringUtil.ALLATORIxDEMO("&\"]JM\"&"));
        symbolMap.put(ManateeSyntax.ALLATORIxDEMO("'"), StringUtil.ALLATORIxDEMO("\"&X]JM\"&"));
        symbolMap.put(",", "##DH##");
        symbolMap.put("|", ManateeSyntax.ALLATORIxDEMO("-vF\u0000Av-"));
        symbolMap.put(StringUtil.ALLATORIxDEMO("#"), ManateeSyntax.ALLATORIxDEMO("-vW\u0000@v-"));
    }

    public static String formatSymbolBack(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getValue();
            object = object.getKey();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    public static String specialSymbolHandle(String a) {
        String string = a;
        String[] stringArray = StringUtils.substringsBetween((String)string, (String)ManateeSyntax.ALLATORIxDEMO(","), (String)StringUtil.ALLATORIxDEMO("'"));
        if (stringArray != null && stringArray.length > 0) {
            int n;
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String string2 = stringArray[n];
                String string3 = ExpressionUtil.specialSymbolReplace(string2);
                StringUtils.replace((String)a, (String)(ManateeSyntax.ALLATORIxDEMO(",") + string2 + StringUtil.ALLATORIxDEMO("'")), (String)new StringBuilder().insert(0, ManateeSyntax.ALLATORIxDEMO(",")).append(string3).append(StringUtil.ALLATORIxDEMO("'")).toString(), (int)1);
                n3 = ++n;
            }
        }
        return string;
    }

    private static /* synthetic */ String ALLATORIxDEMO(String a, int a2) {
        if (a2 < 1) {
            return null;
        }
        String string = a.substring(a2 - 1, a2);
        if (StringUtil.ALLATORIxDEMO("%").equals(string)) {
            return ExpressionUtil.ALLATORIxDEMO(a, a2 - 1);
        }
        return string;
    }

    public ExpressionUtil() {
        ExpressionUtil a;
    }

    public static String specialSymbolReplace(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getKey();
            object = object.getValue();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(String a) {
        try {
            int n;
            Stack<String> stack = new Stack<String>();
            int n2 = n = 0;
            while (n2 < a.length()) {
                String string = a.charAt(n) + "";
                if (a.charAt(n) == '(') {
                    stack.push(string);
                } else if (a.charAt(n) == ')' && (String)stack.pop() == null) {
                    return false;
                }
                n2 = ++n;
            }
            return stack.size() == 0;
        }
        catch (EmptyStackException emptyStackException) {
            return false;
        }
    }

    public static void main(String[] a) {
        System.out.println(ManateeSyntax.ALLATORIxDEMO("\u0004v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-_-u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.v\u0004v.u.u.u.u-v.v.u.v.u.u-v.v-v.v-v.v-u.v-v.u.u.u.u-_-u.u.u.u-u-u-u.u-u.u-u-u.v.u-u-u-u-u.v.u.u.u.u.v\u0004v.u.u.u.v-v.v.u.v.u.v-v.u-u.v.v.v-u.u-u.u.u.u.u-_-u.u.u.u-u-u-v-u-v-u-u-u.v.u-v-u-u-u-v-u.u.u.u.v\u0004v.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u-_-uA7h }6o!g:`ul,.\u0014b9o!a'guA7h }6o!a'.#9{9uJ\u0010C\u001a.v\u0004v.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u-_-u.u.u.u.u.uf!z%4z!\"y\" 4b9o!a'g{m:cu.u.u.u.u.u.v\u0004v.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u.u-_-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v-v\u0004"));
        ExpressionUtil.getConditionList(StringUtil.ALLATORIxDEMO("rl{`)ihvuDea)ihvu,(%hv!knq!ktim%'#!-edudrjtwb`!vudsqrRhqi%#muqq?.*#%}y!a`q`vnpsfd%rq`wuvVlum!'iquur?.*#,"));
    }

    public static boolean isContainsFun(String a) {
        return a.contains(ManateeSyntax.ALLATORIxDEMO("&")) || a.contains(StringUtil.ALLATORIxDEMO(","));
    }
}

