/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.fun.impl.flowChart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.common.util.tool.http.HttpUtil;
import com.manatee.fun.IFunction;
import com.manatee.fun.domain.FunctionContent;
import com.manatee.manager.node.biz.NodeLinkedManager;
import com.manatee.manager.node.biz.NodeProcessManager;
import com.manatee.manager.node.domain.NodeLinked;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.impl.system.ThrowsExceptionProcess;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlowChartTranslateFun
implements IFunction {
    private Logger log = LoggerFactory.getLogger(FlowChartTranslateFun.class);
    private String name = "flowChartTranslate";

    public String getName() {
        return this.name;
    }

    public Object doFunction(FunctionContent content) throws BizException {
        JSONObject steps = new JSONObject();
        List parameters = content.getParameters();
        if (parameters.get(0) == null) {
            return steps;
        }
        Object cellsObj = parameters.get(0);
        Object datasource = null;
        if (parameters.size() == 2) {
            datasource = parameters.get(1);
        }
        JSONArray cells = cellsObj instanceof ArrayList ? new JSONArray((List)((ArrayList)cellsObj)) : (JSONArray)cellsObj;
        boolean needEnd = false;
        if (datasource != null) {
            String datasourceStr = datasource;
            if (datasourceStr.startsWith("http") || datasourceStr.startsWith("https")) {
                JSONObject params;
                String utl = datasourceStr + "/modularity/project0/getManateeVersion";
                String rsuult = HttpUtil.post((String)utl, (String)(params = new JSONObject()).toJSONString());
                if (StrUtil.isNotBlank((CharSequence)rsuult)) {
                    int v;
                    JSONObject jsonObject = JSONObject.parseObject((String)rsuult);
                    String version = jsonObject.getJSONObject("data").getString("currentVersion");
                    String[] split = version.split("\\.");
                    int patchVersion = 0;
                    if (split.length == 4) {
                        patchVersion = Integer.parseInt(split[3]) * 100;
                    }
                    if ((v = Integer.parseInt(split[0]) * 100000000 + Integer.parseInt(split[1]) * 1000000 + Integer.parseInt(split[2]) * 10000 + patchVersion) >= 319050100) {
                        needEnd = true;
                    }
                }
            } else {
                needEnd = true;
            }
        }
        try {
            NodeLinked nodeLinked = NodeLinkedManager.node2Linked(cells);
            steps = needEnd ? NodeProcessManager.node2Process(nodeLinked, true) : NodeProcessManager.node2Process(nodeLinked);
        }
        catch (BizException e2) {
            this.errorLog(e2.getCode(), e2.getSubCode(), e2.getMessage(), 510, content);
        }
        return steps;
    }

    private void errorLog(String code, String subCode, String msg, int status, FunctionContent content) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)code);
        jsonObject.put("resultSubCode", (Object)subCode);
        jsonObject.put("resultMsg", (Object)msg);
        jsonObject.put("resultStatus", (Object)status);
        BizException bizException = ThrowsExceptionProcess.getException(jsonObject, (ProcessContent)content);
        throw new RuntimeException(bizException);
    }
}

